/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.model.SetUpUpnpForwardingResult;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.connector.Connector;

@Service
public class UpnpForwardingService {
    private Logger log = Logger.getLogger(UpnpForwardingService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public SetUpUpnpForwardingResult setUpUpnpForwarding(String deviceId, Integer upnpPort) {
        Response baseResponse;
        this.log.trace((Object)("start setUpUpnpForwarding(deviceId=" + deviceId + ", upnpPort=" + upnpPort + ")"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deviceId", deviceId);
        if (upnpPort != null) {
            params.put("upnpPort", upnpPort.toString());
        }
        if ((baseResponse = this.connector.get(deviceId, this.getPath(deviceId), params, SetUpUpnpForwardingResponse.class)) == null) {
            return null;
        }
        SetUpUpnpForwardingResponse response = (SetUpUpnpForwardingResponse)baseResponse;
        return response.getStatus() == Response.Status.SUCCESS ? response.getResult() : null;
    }

    private String getPath(String deviceId) {
        return "/rest/device/" + deviceId + "/setUpForwarding";
    }
}

