/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.response.CreateTcpProxyResponse;
import com.vestiacom.gdserver.rest.response.ExecuteCommandResponse;
import com.vestiacom.gdserver.rest.response.Response;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.containerserver.connector.Connector;

@Component
public class TcpProxyService {
    private static Logger log = Logger.getLogger(ExecCmdService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Integer createTcpProxy(String deviceId, Integer localPort, String dstAddress, Integer dstPort) {
        log.debug((Object)("start createTcpProxy(deviceId=" + deviceId + ", localPort=" + localPort + ", dstAddress=" + dstAddress + ", dstPort=" + dstPort + ")"));
        String path = "/rest/device/" + deviceId + "/tcpProxy";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("localPort", "" + localPort);
        params.put("dstAddress", dstAddress);
        params.put("dstPort", "" + dstPort);
        Response baseResponse = this.connector.get(deviceId, path, params, ExecuteCommandResponse.class);
        if (baseResponse == null) {
            return null;
        }
        CreateTcpProxyResponse response = (CreateTcpProxyResponse)baseResponse;
        return response.getStatus() == Response.Status.SUCCESS ? response.getLocalPort() : null;
    }
}

