/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.response.CommandResult;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.ExecCmdService;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.util.Utils;

@Service
public class SearchWlanAccessPointsService {
    private static Logger log = Logger.getLogger(SearchWlanAccessPointsService.class);
    private ExecCmdService execCmdService;
    private ParameterService parameterService;
    private LanDeviceDAO lanDeviceDAO;

    @Autowired
    @Required
    public void setExecCmdService(ExecCmdService execCmdService) {
        this.execCmdService = execCmdService;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    public String getUsesScriptsDirectoryMinimalVersion() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.GDCLIENT_MINIMAL_VERSION_WITH_SCRIPTS_DIRECTORY_SUPPORT);
    }

    public String searchWlanAccessPoints(String deviceId) {
        List devices = this.lanDeviceDAO.findNotDeletedLanDevicesByMac(deviceId);
        if (devices.isEmpty()) {
            log.debug((Object)("not found any device for mac=" + deviceId + "."));
            return null;
        }
        CommandResult result = null;
        if (Utils.isAtMinimalVersion((String)((LanDeviceEntity)devices.get(0)).getGatewayClient().getVersion(), (String)this.getUsesScriptsDirectoryMinimalVersion())) {
            log.debug((Object)"Executing scripts/scanwlan.sh on gdclient");
            result = this.execCmdService.executeCommand(deviceId, "scanwlan.sh");
        } else {
            log.debug((Object)"Executing (old) scanwlan.sh on gdclient");
            result = this.execCmdService.executeCommand(deviceId, "./scanwlan.sh");
        }
        if (result != null) {
            log.trace((Object)("search wlan access points result: " + result));
            return result.getOutput();
        }
        log.trace((Object)"search wlan access points result: (null)");
        return null;
    }
}

