/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.rest.response.SearchCandidatesResponse;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.hm.WebViewer.shared.model.Candidates;
import pl.smartapps.hm.WebViewer.shared.model.ICEParams;

@Service(value="searchCandidatesService")
@Scope(value="prototype")
public class SearchCandidatesService {
    private static Logger log = Logger.getLogger(SearchCandidatesService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Candidates searchCandidates(String deviceId, ICEParams iceParams, String candidates) {
        log.debug((Object)("start SearchCandidatesService[" + this + "].searchCandidates(deviceId=" + deviceId + ", iceParams=" + iceParams + ", candidates=" + candidates + ")"));
        String path = "/rest/device/" + deviceId + "/candidates";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stunAddr", iceParams.getStunAddress());
        params.put("stunPort", "" + iceParams.getStunPort());
        params.put("turnPort", "" + iceParams.getTurnPort());
        params.put("turnAddr", iceParams.getTurnAddress());
        params.put("turnUser", iceParams.getTurnUsername());
        params.put("turnPass", iceParams.getTurnPassword());
        params.put("candidates", candidates);
        Response baseResponse = this.connector.get(deviceId, path, params, SearchCandidatesResponse.class);
        if (baseResponse == null) {
            log.warn((Object)("Failed to search candidates for deivceId=" + deviceId + " (iceParams=" + iceParams + ", candidates=" + candidates + "): " + baseResponse));
            return null;
        }
        SearchCandidatesResponse response = (SearchCandidatesResponse)baseResponse;
        if (response.getStatus() == Response.Status.SUCCESS) {
            Candidates foundCandidates = new Candidates();
            foundCandidates.setCandidates(response.getCandidates());
            foundCandidates.setPortRangeStart(response.getPortRangeStart().intValue());
            foundCandidates.setPortRangeEnd(response.getPortRangeEnd().intValue());
            return foundCandidates;
        }
        log.warn((Object)("Failure status for search candidates for deivceId=" + deviceId + " (iceParams=" + iceParams + ", candidates=" + candidates + ")"));
        return null;
    }
}

