/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.util.Utils;

@Component
public class HttpClientFactory {
    private static Logger log = Logger.getLogger(HttpClientFactory.class);
    private ParameterService parameterService;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public HttpClient getHttpClient() {
        return this.getHttpClient(false);
    }

    public HttpClient getHttpClient(boolean allowUnsecured) {
        try {
            HttpClient httpClient = this.getClient(allowUnsecured);
            String proxyAddress = this.parameterService.getParameterValue(ParameterService.ParameterCode.HTTPCLIENT_PROXY_ADDRESS);
            if (!Utils.isBlank((String)proxyAddress)) {
                Integer proxyPort = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.HTTPCLIENT_PROXY_PORT);
                log.debug((Object)("Creating HttpClient with proxy: " + proxyAddress + ", " + proxyPort));
                if (proxyPort == null) {
                    log.error((Object)"Not found proxy port.");
                    throw new NullPointerException("proxy port");
                }
                HttpHost proxy = new HttpHost(proxyAddress, proxyPort.intValue());
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            } else {
                log.debug((Object)"Creating HttpClient without proxy");
            }
            return httpClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HttpClient getClient(boolean allowUnsecured) throws Exception {
        if (allowUnsecured) {
            log.debug((Object)"Creating HttpClient accepts all certificates");
            X509HostnameVerifier hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */}, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            sf.setHostnameVerifier(hostnameVerifier);
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
            Scheme httpScheme = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(httpsScheme);
            schemeRegistry.register(httpScheme);
            SingleClientConnManager cm = new SingleClientConnManager(schemeRegistry);
            return new DefaultHttpClient((ClientConnectionManager)cm);
        }
        return new DefaultHttpClient();
    }
}

