/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.google.gson.Gson;
import com.vestiacom.gdserver.rest.model.HttpCommand;
import com.vestiacom.gdserver.rest.response.ExecuteHttpCommandResponse;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import com.vestiacom.gdserver.rest.response.Response;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.connector.Connector;

@Service(value="httpClientService")
@Scope(value="prototype")
public class HTTPClientService {
    private static Logger log = Logger.getLogger(HTTPClientService.class);
    private Connector connector;
    private HttpCommand.ConnectionType connectionType;
    private Integer timeout;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setConnectionType(HttpCommand.ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public HTTPClientServiceResult get(String deviceId, URL url) {
        try {
            HttpCommand command = new HttpCommand();
            command.setMethod(HttpCommand.SendMethod.GET);
            command.setUrl(url.toString());
            command.setConnectionType(this.connectionType);
            command.setTimeout(this.timeout);
            Gson gson = new Gson();
            StringEntity entity = new StringEntity(gson.toJson((Object)command), "application/json", "UTF8");
            Response baseResponse = this.connector.post(deviceId, this.getPath(deviceId), null, (HttpEntity)entity, ExecuteHttpCommandResponse.class);
            if (baseResponse == null) {
                log.warn((Object)("Failed to execute http command: " + command + "."));
                return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
            }
            ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)baseResponse;
            if (response.getStatus() == Response.Status.FAILURE) {
                log.warn((Object)("Failure status for execute http command: " + command));
                return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
            }
            if (response.getStatus() == Response.Status.CLUSTER_NOT_CONNECTED) {
                return new HTTPClientServiceResult(HTTPClientServiceResult.Result.NOANSWER);
            }
            if (response.getStatus() == Response.Status.ANOTHER_NODE_CONNECTED) {
                log.warn((Object)"This should not happen");
                return new HTTPClientServiceResult(HTTPClientServiceResult.Result.NOANSWER);
            }
            return response.getResult();
        }
        catch (UnsupportedEncodingException ex) {
            log.warn((Object)("Failed to execute GET command: " + ex.getMessage()));
            return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
        }
    }

    private String getPath(String deviceId) {
        return "/rest/device/" + deviceId + "/httpclient";
    }

    public HTTPClientServiceResult post(String deviceId, URL url) {
        return this.post(deviceId, url, null, url.getQuery().getBytes());
    }

    public HTTPClientServiceResult post(String deviceId, URL url, Map<String, String> additionalRequestHeaders, byte[] body) {
        try {
            HttpCommand command = new HttpCommand();
            command.setMethod(HttpCommand.SendMethod.POST);
            command.setUrl(url.toString());
            command.setConnectionType(this.connectionType);
            command.setHeaders(additionalRequestHeaders);
            command.setBody(Base64.encodeBase64String((byte[])body));
            Gson gson = new Gson();
            StringEntity entity = new StringEntity(gson.toJson((Object)command), "application/json", "UTF8");
            Response baseResponse = this.connector.post(deviceId, this.getPath(deviceId), null, (HttpEntity)entity, ExecuteHttpCommandResponse.class);
            if (baseResponse == null) {
                log.warn((Object)("Failed to execute http command: " + command + "."));
                return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
            }
            ExecuteHttpCommandResponse response = (ExecuteHttpCommandResponse)baseResponse;
            if (response.getStatus() == Response.Status.FAILURE) {
                log.warn((Object)("Failure status for execute http command: " + command));
                return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
            }
            return response.getResult();
        }
        catch (UnsupportedEncodingException ex) {
            log.warn((Object)("Failed to execute POST command: " + ex.getMessage()));
            return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
        }
    }
}

