/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.response.ForceUpgradeResponse;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.GetDeviceResponse;
import com.vestiacom.gdserver.rest.response.Response;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.connector.Connector;

@Service
public class GatewayDeviceConnectionService {
    private static Logger log = Logger.getLogger(GatewayDeviceConnectionService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public GatewayDevice findById(String deviceId) {
        log.debug((Object)("start findById(deviceId=" + deviceId + ")"));
        Response baseResponse = this.connector.get(deviceId, "/rest/device/" + deviceId, null, GetDeviceResponse.class);
        if (baseResponse == null) {
            return null;
        }
        GetDeviceResponse response = (GetDeviceResponse)baseResponse;
        return response.getDevice();
    }

    public boolean forceUpgrade(String deviceId) {
        log.debug((Object)("start forceUpgrade(deviceId=" + deviceId + ")"));
        String path = "/rest/device/" + deviceId + "/forceUpgrade";
        Response baseResponse = this.connector.get(deviceId, path, null, ForceUpgradeResponse.class);
        if (baseResponse == null) {
            return false;
        }
        ForceUpgradeResponse response = (ForceUpgradeResponse)baseResponse;
        return response.getStatus() == Response.Status.SUCCESS;
    }
}

