/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.response.CommandResult;
import com.vestiacom.gdserver.rest.response.ExecuteCommandResponse;
import com.vestiacom.gdserver.rest.response.Response;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.containerserver.connector.Connector;

@Component
public class ExecCmdService {
    private static Logger log = Logger.getLogger(ExecCmdService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public CommandResult executeCommand(String deviceId, String command, Long timeout) {
        Response baseResponse;
        log.debug((Object)("start executeCommand(deviceId=" + deviceId + ", command=" + command + ", timeout=" + timeout + ")"));
        String path = "/rest/device/" + deviceId + "/executeCommand";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("command", command);
        if (timeout != null) {
            params.put("timeout", timeout.toString());
        }
        if ((baseResponse = this.connector.get(deviceId, path, params, ExecuteCommandResponse.class)) == null) {
            return null;
        }
        ExecuteCommandResponse response = (ExecuteCommandResponse)baseResponse;
        return response.getStatus() == Response.Status.SUCCESS ? response.getResult() : null;
    }

    public CommandResult executeCommand(String deviceId, String command) {
        return this.executeCommand(deviceId, command, null);
    }
}

