/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.rest.response.AddDomainNameResponse;
import com.vestiacom.gdserver.rest.response.RemoveDomainNameResponse;
import com.vestiacom.gdserver.rest.response.Response;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.DomainNameService;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.restserver.util.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DomainNameService.class, DomainName.class, Utils.class})
public class DomainNameServiceTests {
    private DomainNameService domainNameService;
    private Connector connector;

    @Before
    public void setUp() {
        this.domainNameService = new DomainNameService();
        this.connector = (Connector)PowerMock.createMock(Connector.class);
        this.domainNameService.setConnector(this.connector);
        PowerMock.mockStatic(Utils.class);
    }

    @Test
    public void testUpdateDnsRecordSuccessfully() throws Exception {
        String domain = "testDomain";
        String mac = "tesetMac";
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{domain, mac, type}).andReturn((Object)domainName);
        StringEntity entity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)entity);
        entity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(mac, "/rest/dns", null, (HttpEntity)entity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainNameService.createRecord(domain, mac, type);
        Assert.assertEquals((Object)true, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDnsRecordUnsupportedEncoding() throws Exception {
        String domain = "testDomain";
        String mac = "tesetMac";
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{domain, mac, type}).andReturn((Object)domainName);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andThrow((Throwable)new UnsupportedEncodingException());
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainNameService.createRecord(domain, mac, type);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDnsRecordFailure() throws Exception {
        String domain = "testDomain";
        String mac = "tesetMac";
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{domain, mac, type}).andReturn((Object)domainName);
        StringEntity entity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)entity);
        entity.setContentType("application/json");
        AddDomainNameResponse response = (AddDomainNameResponse)PowerMock.createMock(AddDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.post(mac, "/rest/dns", null, (HttpEntity)entity, AddDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.FAILURE);
        EasyMock.expect((Object)response.getErrorCode()).andReturn((Object)AddDomainNameResponse.ErrorCode.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainNameService.createRecord(domain, mac, type);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDnsRecordNullResponse() throws Exception {
        String domain = "testDomain";
        String mac = "tesetMac";
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        DomainName domainName = (DomainName)PowerMock.createMock(DomainName.class);
        PowerMock.expectNew(DomainName.class, (Object[])new Object[]{domain, mac, type}).andReturn((Object)domainName);
        StringEntity entity = (StringEntity)PowerMock.createMock(StringEntity.class);
        EasyMock.expect((Object)Utils.createEntity((Object)domainName)).andReturn((Object)entity);
        entity.setContentType("application/json");
        EasyMock.expect((Object)this.connector.post(mac, "/rest/dns", null, (HttpEntity)entity, AddDomainNameResponse.class)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainNameService.createRecord(domain, mac, type);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateDnsRecordNoType() throws Exception {
        String domain = "testDomain";
        String mac = "tesetMac";
        DomainName.AddressType type = null;
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainNameService.createRecord(domain, mac, type);
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpdateDnsRecordNoMac() throws Exception {
        String domain = null;
        String mac = "tesetMac";
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect((Object)Utils.isBlank(domain)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainNameService.createRecord(domain, mac, type);
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpdateDnsRecordNoDomain() throws Exception {
        String domain = "testDomain";
        String mac = null;
        DomainName.AddressType type = DomainName.AddressType.LOCAL;
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainNameService.createRecord(domain, mac, type);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveDnsRecordSuccessfully() {
        String domain = "testDomain";
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        String path = "/rest/dns/" + domain;
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)PowerMock.createMock(RemoveDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.delete(null, path, null, RemoveDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainNameService.deleteRecord(domain);
        Assert.assertEquals((Object)true, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveDnsRecordFailure() {
        String domain = "testDomain";
        EasyMock.expect((Object)Utils.isBlank((String)domain)).andReturn((Object)false);
        String path = "/rest/dns/" + domain;
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)PowerMock.createMock(RemoveDomainNameResponse.class);
        EasyMock.expect((Object)this.connector.delete(null, path, null, RemoveDomainNameResponse.class)).andReturn((Object)response);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)Response.Status.FAILURE);
        EasyMock.expect((Object)response.getErrorCode()).andReturn((Object)RemoveDomainNameResponse.ErrorCode.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        boolean actual = this.domainNameService.deleteRecord(domain);
        Assert.assertEquals((Object)false, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveDnsRecordNoDomain() {
        String domain = null;
        EasyMock.expect((Object)Utils.isBlank(domain)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.domainNameService.deleteRecord(domain);
        PowerMock.verifyAll();
    }
}

