/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.rest.response.AddDomainNameResponse;
import com.vestiacom.gdserver.rest.response.GetDomainNameResponse;
import com.vestiacom.gdserver.rest.response.RemoveDomainNameResponse;
import com.vestiacom.gdserver.rest.response.Response;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.util.ExceptionsTrigger;
import pl.smartapps.restserver.util.Utils;

@Service
public class DomainNameService {
    private static Logger log = Logger.getLogger(DomainNameService.class);
    private Connector connector;
    private ParameterService parameterService;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    private String getDnsimpleDomain() {
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.DNSIMPLE_DOMAIN);
    }

    public String getAddress(String name) {
        String domain = this.getDnsimpleDomain();
        return name == null || name.trim().isEmpty() ? domain : String.valueOf(name) + "." + domain;
    }

    public String getName(String address) {
        String domain = this.getDnsimpleDomain();
        return address.replace("." + domain, "");
    }

    public boolean createRecord(String domain, String mac, DomainName.AddressType type) {
        AddDomainNameResponse response;
        block5: {
            log.trace((Object)("start updateDnsRecord(domain=" + domain + ", mac=" + mac + ", type=" + type + ")"));
            ExceptionsTrigger.throwIfBlank((String)domain, (RuntimeException)new IllegalArgumentException("domain is blank"));
            ExceptionsTrigger.throwIfBlank((String)mac, (RuntimeException)new IllegalArgumentException("mac is blank"));
            ExceptionsTrigger.throwIfNull((Object)type, (RuntimeException)new NullPointerException("type"));
            try {
                HttpEntity entity = this.createDomainNameEntity(this.getAddress(domain), mac, type);
                response = (AddDomainNameResponse)this.connector.post(mac, "/rest/dns", null, entity, AddDomainNameResponse.class);
                if (response != null) break block5;
                log.warn((Object)("Failed to update dns record for domain=" + domain + ", mac=" + mac + ", type=" + type + "; cause: response null"));
                return false;
            }
            catch (UnsupportedEncodingException ex) {
                log.warn((Object)("Failed to update dns record for domain=" + domain + ", mac=" + mac + ", type=" + type + "; cause: " + ex.getMessage()));
                if (log.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                return false;
            }
        }
        if (response.getStatus() != Response.Status.SUCCESS) {
            log.warn((Object)("Failed to update dns record for domain=" + domain + ", mac=" + mac + ", type=" + type + "; cause: " + response.getErrorCode()));
            return false;
        }
        return true;
    }

    private HttpEntity createDomainNameEntity(String domain, String mac, DomainName.AddressType type) throws UnsupportedEncodingException {
        DomainName domainName = new DomainName(domain, mac, type);
        StringEntity entity = Utils.createEntity((Object)domainName);
        entity.setContentType("application/json");
        return entity;
    }

    public boolean deleteRecord(String domain) {
        log.trace((Object)("start removeDnsRecord(domain=" + domain + ")"));
        ExceptionsTrigger.throwIfBlank((String)domain, (RuntimeException)new IllegalArgumentException("domain is blank"));
        String path = "/rest/dns/" + domain;
        RemoveDomainNameResponse response = (RemoveDomainNameResponse)this.connector.delete(null, path, null, RemoveDomainNameResponse.class);
        if (response == null) {
            log.warn((Object)("Failed to remove dns record for domain=" + domain + "; cause: response null"));
            return false;
        }
        if (response.getStatus() != Response.Status.SUCCESS) {
            log.warn((Object)("Failed to remove dns record for domain=" + domain + "; cause: " + response.getErrorCode()));
            return false;
        }
        return true;
    }

    public DomainName getRecord(String domain) {
        log.trace((Object)("start getRecord(domain=" + domain + ")"));
        ExceptionsTrigger.throwIfBlank((String)domain, (RuntimeException)new IllegalArgumentException("domain is blank"));
        String path = "/rest/dns/" + domain;
        GetDomainNameResponse response = (GetDomainNameResponse)this.connector.get(null, path, null, GetDomainNameResponse.class);
        if (response == null) {
            log.warn((Object)("Failed to get dns record for domain=" + domain + "; cause: response null"));
            return null;
        }
        if (response.getStatus() != Response.Status.SUCCESS) {
            log.warn((Object)("Failed to get dns record for domain=" + domain + "; cause: " + response.getErrorCode()));
            return null;
        }
        return response.getDomainName();
    }
}

