/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.containerserver;

import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import com.vestiacom.gdserver.rest.response.ConfigureLoggerResponse;
import com.vestiacom.gdserver.rest.response.Response;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import pl.smartapps.containerserver.connector.Connector;

public class ConfigureGCLogsService {
    private static Logger log = Logger.getLogger(ConfigureGCLogsService.class);
    private Connector connector;

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public LoggerConfigurationStatus configureLogs(String deviceId, String logsConfiguration) {
        log.debug((Object)("start configureLogs(deviceId=" + deviceId + ", logsConfiguration=" + logsConfiguration + ")"));
        String path = "/device/" + deviceId + "/log";
        try {
            StringEntity entity = new StringEntity(logsConfiguration, "text/plain", "UTF8");
            Response baseResponse = this.connector.post(deviceId, path, null, (HttpEntity)entity, ConfigureLoggerResponse.class);
            if (baseResponse == null) {
                log.warn((Object)("Failed to configure logger for deivceId=" + deviceId + " (deviceId=" + deviceId + ", logsConfiguration=" + logsConfiguration + ")"));
                return LoggerConfigurationStatus.ERROR;
            }
            ConfigureLoggerResponse response = (ConfigureLoggerResponse)baseResponse;
            if (response.getStatus() == Response.Status.SUCCESS) {
                return response.getConfigurationResult();
            }
            log.warn((Object)("Failure status for search candidates for deivceId=" + deviceId + " (deviceId=" + deviceId + ", logsConfiguration=" + logsConfiguration + ")"));
            return LoggerConfigurationStatus.ERROR;
        }
        catch (UnsupportedEncodingException ex) {
            log.warn((Object)("Failed to configure logger: " + ex.getMessage()));
            return LoggerConfigurationStatus.ERROR;
        }
    }
}

