/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.codegenerator;

import org.apache.log4j.Logger;
import pl.smartapps.codegenerator.CRC4;
import pl.smartapps.codegenerator.Utils;

public class GCActivationCodeGenerator {
    private static final String DICTIONARY = "abcdefghijkmnopqrstuwxyz23456789";
    private static Logger log = Logger.getLogger(GCActivationCodeGenerator.class);

    public String generateCode(String macAddress, String deviceHash) {
        log.debug((Object)("start generate(macAddress=" + macAddress + ", deviceHash=" + deviceHash + ")"));
        if (!this.validateMacAddress(macAddress)) {
            throw new IllegalArgumentException("Incorrect mac address: '" + macAddress + "'.");
        }
        if (deviceHash == null || deviceHash.trim().length() == 0) {
            throw new IllegalArgumentException("Incorrect device hash: '" + deviceHash + "'.");
        }
        byte[] mac = this.macAddressToByteArray(macAddress);
        byte hash = (byte)Integer.parseInt(deviceHash);
        int i = 0;
        while (i < mac.length) {
            mac[i] = (byte)(mac[i] ^ hash);
            ++i;
        }
        byte[] crcBase = new byte[7];
        System.arraycopy(mac, 0, crcBase, 0, 6);
        crcBase[6] = hash;
        int crc = CRC4.calculate((byte[])crcBase);
        log.debug((Object)("Generated crc for " + Utils.byteArrayToString((byte[])crcBase) + ": " + (crc <<= 4)));
        byte[] payload = new byte[8];
        System.arraycopy(crcBase, 0, payload, 0, 7);
        payload[7] = (byte)crc;
        log.debug((Object)("Prepared payload: " + Utils.byteArrayToString((byte[])payload) + "."));
        String code = this.encode(payload);
        log.debug((Object)("Generated raw code: " + code + "."));
        return this.formatCode(code);
    }

    private String[] splitMacAddress(String mac) {
        mac = mac.replace(":", "");
        String[] macSegments = new String[6];
        int i = 0;
        while (i < 6) {
            macSegments[i] = mac.substring(i * 2, 2 * (i + 1));
            ++i;
        }
        return macSegments;
    }

    private byte[] macAddressToByteArray(String mac) {
        byte[] result = new byte[6];
        String[] macSegments = this.splitMacAddress(mac);
        int i = 0;
        while (i < 6) {
            int segment = Integer.parseInt(macSegments[i], 16);
            result[i] = (byte)segment;
            ++i;
        }
        return result;
    }

    private boolean validateMacAddress(String macAddress) {
        if (macAddress == null || macAddress.trim().length() == 0) {
            log.debug((Object)"Mac address is null or its length is zero!");
            return false;
        }
        if (macAddress.contains(":") && macAddress.length() != 17) {
            log.debug((Object)"Invalid mac address length!");
            return false;
        }
        if (!macAddress.contains(":") && macAddress.length() != 12) {
            log.debug((Object)"Invalid mac address length!");
            return false;
        }
        if (!macAddress.replace(":", "").toLowerCase().matches("[a-f0-9]{12}")) {
            log.debug((Object)"Mac addres contains illegal characters!");
            return false;
        }
        return true;
    }

    private String formatCode(String code) {
        if (code == null || code.length() < 12) {
            throw new IllegalArgumentException("Incorrect code (null or invalid length): " + code);
        }
        code = code.substring(0, 12);
        StringBuilder formattedCode = new StringBuilder();
        formattedCode.append(code.substring(0, 4));
        formattedCode.append("-");
        formattedCode.append(code.substring(4, 8));
        formattedCode.append("-");
        formattedCode.append(code.substring(8));
        return formattedCode.toString();
    }

    private String encode(byte[] payload) {
        log.debug((Object)("start encode(payload=" + Utils.byteArrayToString((byte[])payload) + ")"));
        String encoded = "";
        int paddingCount = (5 - payload.length % 5) % 5;
        payload = this.zeroPad(payload.length + paddingCount, payload);
        log.debug((Object)("Padded payload: " + Utils.byteArrayToString((byte[])payload, (String)", ")));
        int i = 0;
        while (i < payload.length) {
            log.debug((Object)"Processing bytes group.");
            long j = ((long)(payload[i] & 0xFF) << 32) + ((long)(payload[i + 1] & 0xFF) << 24) + ((long)(payload[i + 2] & 0xFF) << 16) + ((long)(payload[i + 3] & 0xFF) << 8) + (long)(payload[i + 4] & 0xFF);
            log.debug((Object)("j: " + j));
            encoded = String.valueOf(encoded) + DICTIONARY.charAt((int)(j >> 35 & 0x1FL)) + DICTIONARY.charAt((int)(j >> 30 & 0x1FL)) + DICTIONARY.charAt((int)(j >> 25 & 0x1FL)) + DICTIONARY.charAt((int)(j >> 20 & 0x1FL)) + DICTIONARY.charAt((int)(j >> 15 & 0x1FL)) + DICTIONARY.charAt((int)(j >> 10 & 0x1FL)) + DICTIONARY.charAt((int)(j >> 5 & 0x1FL)) + DICTIONARY.charAt((int)(j & 0x1FL));
            i += 5;
        }
        return encoded;
    }

    private byte[] zeroPad(int length, byte[] bytes) {
        byte[] padded = new byte[length];
        System.arraycopy(bytes, 0, padded, 0, bytes.length);
        return padded;
    }

    private String decode(String code) {
        log.debug((Object)("start decode(code=" + code + ")"));
        int rem = code.length() % 8;
        if (rem != 0) {
            int i = 0;
            while (i < 8 - rem) {
                code = String.valueOf(code) + "a";
                ++i;
            }
        }
        log.debug((Object)("Processing code: " + code));
        String decoded = "";
        int i = 0;
        while (i < code.length()) {
            long j = 0L;
            j += (long)DICTIONARY.indexOf(code.charAt(i)) << 35;
            j += (long)DICTIONARY.indexOf(code.charAt(i + 1)) << 30;
            j += (long)DICTIONARY.indexOf(code.charAt(i + 2)) << 25;
            j += (long)DICTIONARY.indexOf(code.charAt(i + 3)) << 20;
            j += (long)DICTIONARY.indexOf(code.charAt(i + 4)) << 15;
            j += (long)DICTIONARY.indexOf(code.charAt(i + 5)) << 10;
            j += (long)DICTIONARY.indexOf(code.charAt(i + 6)) << 5;
            log.debug((Object)("j: " + (j += (long)DICTIONARY.indexOf(code.charAt(i + 7)))));
            byte[] batch = new byte[]{(byte)(j >> 32 & 0xFFL), (byte)(j >> 24 & 0xFFL), (byte)(j >> 16 & 0xFFL), (byte)(j >> 8 & 0xFFL), (byte)(j >> 0 & 0xFFL)};
            decoded = String.valueOf(decoded) + Utils.byteArrayToString((byte[])batch);
            i += 8;
        }
        log.debug((Object)("Decoded value for code '" + code + "': " + decoded + "."));
        return decoded;
    }

    public String decodeCode(String code) {
        if (!this.validateCode(code)) {
            return null;
        }
        String decodedCode = this.decode(code.replace("-", ""));
        if (this.validateDecodedCode(decodedCode)) {
            String macText = decodedCode.substring(0, 12);
            byte[] mac = this.macAddressToByteArray(macText);
            byte hash = (byte)Integer.parseInt(decodedCode.substring(12, 14), 16);
            int i = 0;
            while (i < mac.length) {
                mac[i] = (byte)(mac[i] ^ hash);
                ++i;
            }
            return String.valueOf(Utils.byteArrayToString((byte[])mac)) + decodedCode.substring(12);
        }
        return null;
    }

    private boolean validateCode(String code) {
        log.debug((Object)("start validateCode(code=" + code + ")"));
        if (code == null || code.trim().length() == 0) {
            return false;
        }
        String regex = "([abcdefghijkmnopqrstuwxyz23456789]{4}-){2}[abcdefghijkmnopqrstuwxyz23456789]{4}";
        return code.matches(regex);
    }

    private boolean validateDecodedCode(String code) {
        log.debug((Object)("start validateDecodedCode(code=" + code + ")"));
        String crcBaseText = code.substring(0, 14);
        byte[] crcBase = this.convertToByteArray(crcBaseText);
        int crc = Integer.parseInt(code.substring(14, 16), 16) >> 4;
        return CRC4.calculate((byte[])crcBase) == crc;
    }

    private String[] splitText(String text) {
        int segCount = text.length() / 2;
        String[] segments = new String[segCount];
        int i = 0;
        while (i < segCount) {
            segments[i] = text.substring(i * 2, 2 * (i + 1));
            ++i;
        }
        return segments;
    }

    private byte[] convertToByteArray(String text) {
        int segCount = text.length() / 2;
        byte[] result = new byte[segCount];
        String[] segments = this.splitText(text);
        int i = 0;
        while (i < segCount) {
            int segment = Integer.parseInt(segments[i], 16);
            result[i] = (byte)segment;
            ++i;
        }
        return result;
    }
}

