/*
 * Decompiled with CFR 0.152.
 */
package com.vg.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedBandwidthInputStream
extends FilterInputStream {
    private final long limit;
    private long count;
    private final long startTime = System.currentTimeMillis();
    private long check;
    private final long firstBurst;

    public LimitedBandwidthInputStream(InputStream in, long limit, long firstBurst) {
        super(in);
        this.limit = limit;
        this.firstBurst = firstBurst;
    }

    @Override
    public int read() throws IOException {
        int found = super.read();
        this.count += (long)(found >= 0 ? 1 : 0);
        this.check += (long)(found >= 0 ? 1 : 0);
        this.tryLimit();
        return found;
    }

    private void tryLimit() {
        if (this.count > this.firstBurst && this.check >= 4096L) {
            long time = System.currentTimeMillis() - this.startTime + 1L;
            long bps = this.count * 1000L / time;
            if (bps > this.limit) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.check = 0L;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int found = super.read(b, off, len);
        this.count += (long)(found >= 0 ? found : 0);
        this.check += (long)(found >= 0 ? found : 0);
        this.tryLimit();
        return found;
    }
}

