/*
 * Decompiled with CFR 0.152.
 */
package com.vg.util;

import com.vg.util.LimitedInputStream;
import com.vg.util.SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ContentRange {
    private final long end;
    private final long start;
    private final long count;
    private final long totalLength;

    public ContentRange(long start, long end, long totalLength) {
        this.end = end;
        this.start = start;
        this.totalLength = totalLength;
        this.count = end - start + 1L;
    }

    public static ContentRange parseRange(String headerValue, long fileLength) {
        String[] string = headerValue.split("=")[1].split("-");
        long start = Long.parseLong(string[0]);
        long end = string.length == 1 ? fileLength - 1L : Long.parseLong(string[1]);
        return new ContentRange(start, end, fileLength);
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public long getCount() {
        return this.count;
    }

    public String toString() {
        return "ContentRange [start=" + this.start + ", end=" + this.end + ", count=" + this.count + ", totalLength=" + this.totalLength + "]";
    }

    public String toHeaderValue() {
        return "bytes " + this.start + "-" + this.end + "/" + this.totalLength;
    }

    public long getContentLength() {
        return this.count;
    }

    public InputStream limitedInputStream(SeekableInputStream in) throws IOException {
        in.seek(this.getStart());
        return new LimitedInputStream((InputStream)in, this.getCount());
    }
}

