/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.keys;

import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.ec.parameters.CurveParams;
import de.flexiprovider.ec.parameters.ECParameters;

public class ECPublicKey
extends PublicKey {
    private Point mW;
    private byte[] mEncodedW;
    private CurveParams mParams;

    protected ECPublicKey(Point w, CurveParams params) {
        this.mW = w;
        this.mParams = params;
    }

    protected ECPublicKey(byte[] encodedW) {
        this.mEncodedW = encodedW;
    }

    public Point getW() throws InvalidKeyException {
        if (this.mW == null) {
            throw new InvalidKeyException("No ecdomain parameters defined for the public point");
        }
        return this.mW;
    }

    public byte[] getEncodedW() {
        if (this.mEncodedW != null) {
            return this.mEncodedW;
        }
        return this.mW.EC2OSP(0);
    }

    public CurveParams getParams() {
        return this.mParams;
    }

    public String getAlgorithm() {
        return "EC";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.mEncodedW != null) {
            result.append("W= (encoded)\n");
            result.append(ByteUtils.toHexString(this.mEncodedW, "0x", ""));
        } else {
            result.append("W =\n" + this.mW.toString());
            if (this.mParams != null) {
                result.append("\n" + this.mParams.toString());
            }
        }
        return result.toString();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ECPublicKey)) {
            return false;
        }
        ECPublicKey otherKey = (ECPublicKey)other;
        return ByteUtils.equals(this.getEncoded(), otherKey.getEncoded());
    }

    public int hashCode() {
        return this.mW.hashCode() + this.mParams.getR().hashCode() + this.mParams.getQ().hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.2.840.10045.2.1");
    }

    protected ASN1Type getAlgParams() {
        if (this.mParams == null) {
            return new ASN1Null();
        }
        Object algParams = this.mParams.getOID();
        if (algParams == null) {
            ECParameters ecParams = new ECParameters();
            try {
                ecParams.init(this.mParams);
            }
            catch (InvalidParameterSpecException e) {
                throw new RuntimeException("internal error");
            }
            algParams = ecParams.getASN1Params();
        }
        return algParams;
    }

    protected byte[] getKeyData() {
        byte[] keyBytes = this.mEncodedW == null ? this.mW.EC2OSP(0) : this.mEncodedW;
        return keyBytes;
    }
}

