/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.keys;

import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.pkcs8.PrivateKeyInfo;
import codec.x509.SubjectPublicKeyInfo;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeyFactory;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurve;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGF2n;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGFP;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.ellipticcurves.PointGF2n;
import de.flexiprovider.common.math.ellipticcurves.PointGFP;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.ec.keys.ECPrivateKey;
import de.flexiprovider.ec.keys.ECPrivateKeySpec;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.keys.ECPublicKeySpec;
import de.flexiprovider.ec.parameters.CurveParams;
import de.flexiprovider.pki.AlgorithmIdentifier;
import de.flexiprovider.pki.PKCS8EncodedKeySpec;
import de.flexiprovider.pki.PKITools;
import de.flexiprovider.pki.X509EncodedKeySpec;

public class ECKeyFactory
extends KeyFactory {
    public static final String OID = "1.2.840.10045.2.1";
    static /* synthetic */ Class class$de$flexiprovider$ec$parameters$CurveParams;
    static /* synthetic */ Class class$de$flexiprovider$pki$X509EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$ec$keys$ECPublicKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$pki$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$ec$keys$ECPrivateKeySpec;

    public PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPrivateKeySpec) {
            return new ECPrivateKey((ECPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] encKey = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            PrivateKeyInfo pki = new PrivateKeyInfo();
            try {
                ASN1Tools.derDecode(encKey, (ASN1Type)pki);
                ASN1Sequence privKeySequence = (ASN1Sequence)pki.getDecodedRawKey();
                ASN1OctetString oct = (ASN1OctetString)privKeySequence.get(1);
                FlexiBigInt priv = new FlexiBigInt(1, oct.getByteArray());
                AlgorithmIdentifier algId = PKITools.getAlgorithmIdentifier(pki);
                AlgorithmParameters params = algId.getParams();
                CurveParams paramSpec = (CurveParams)params.getParameterSpec(class$de$flexiprovider$ec$parameters$CurveParams == null ? (class$de$flexiprovider$ec$parameters$CurveParams = ECKeyFactory.class$("de.flexiprovider.ec.parameters.CurveParams")) : class$de$flexiprovider$ec$parameters$CurveParams);
                return new ECPrivateKey(priv, paramSpec);
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec + ".");
    }

    public PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof ECPublicKeySpec) {
            ECPublicKeySpec ecPubSpec = (ECPublicKeySpec)keySpec;
            if (ecPubSpec.getParams() != null) {
                return new ECPublicKey(ecPubSpec.getW(), ecPubSpec.getParams());
            }
            return new ECPublicKey(ecPubSpec.getEncodedW());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] encKey = ((X509EncodedKeySpec)keySpec).getEncoded();
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo();
            try {
                ASN1Tools.derDecode(encKey, (ASN1Type)spki);
                byte[] pubKeyBytes = spki.getRawKey();
                AlgorithmIdentifier algId = PKITools.getAlgorithmIdentifier(spki);
                AlgorithmParameters aparam = algId.getParams();
                if (aparam == null) {
                    return new ECPublicKey(pubKeyBytes);
                }
                CurveParams ecParamSpec = (CurveParams)aparam.getParameterSpec(class$de$flexiprovider$ec$parameters$CurveParams == null ? (class$de$flexiprovider$ec$parameters$CurveParams = ECKeyFactory.class$("de.flexiprovider.ec.parameters.CurveParams")) : class$de$flexiprovider$ec$parameters$CurveParams);
                EllipticCurve mE = ecParamSpec.getE();
                Point mW = null;
                if (mE instanceof EllipticCurveGFP) {
                    mW = new PointGFP(pubKeyBytes, (EllipticCurveGFP)mE);
                } else if (mE instanceof EllipticCurveGF2n) {
                    mW = new PointGF2n(pubKeyBytes, (EllipticCurveGF2n)mE);
                } else {
                    throw new InvalidKeySpecException("EllipticCurve must be an instance either of EllipticCurveGFP or EllipticCurveGF2n.");
                }
                return new ECPublicKey(mW, ecParamSpec);
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec + ".");
    }

    public KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof ECPublicKey) {
            if ((class$de$flexiprovider$pki$X509EncodedKeySpec == null ? (class$de$flexiprovider$pki$X509EncodedKeySpec = ECKeyFactory.class$("de.flexiprovider.pki.X509EncodedKeySpec")) : class$de$flexiprovider$pki$X509EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$ec$keys$ECPublicKeySpec == null ? (class$de$flexiprovider$ec$keys$ECPublicKeySpec = ECKeyFactory.class$("de.flexiprovider.ec.keys.ECPublicKeySpec")) : class$de$flexiprovider$ec$keys$ECPublicKeySpec).isAssignableFrom(keySpec)) {
                ECPublicKey pubKey = (ECPublicKey)key;
                Point w = null;
                try {
                    w = pubKey.getW();
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException("No EC domain parameters defined for this key. KeySpec cannot be generated.");
                }
                return new ECPublicKeySpec(w, pubKey.getParams());
            }
        } else if (key instanceof ECPrivateKey) {
            if ((class$de$flexiprovider$pki$PKCS8EncodedKeySpec == null ? (class$de$flexiprovider$pki$PKCS8EncodedKeySpec = ECKeyFactory.class$("de.flexiprovider.pki.PKCS8EncodedKeySpec")) : class$de$flexiprovider$pki$PKCS8EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$ec$keys$ECPrivateKeySpec == null ? (class$de$flexiprovider$ec$keys$ECPrivateKeySpec = ECKeyFactory.class$("de.flexiprovider.ec.keys.ECPrivateKeySpec")) : class$de$flexiprovider$ec$keys$ECPrivateKeySpec).isAssignableFrom(keySpec)) {
                ECPrivateKey privKey = (ECPrivateKey)key;
                return new ECPrivateKeySpec(privKey.getS(), privKey.getParams());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec + ".");
    }

    public Key translateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof ECPublicKey) {
                if (key instanceof ECPublicKey) {
                    return key;
                }
                ECPublicKeySpec ecPubKeySpec = (ECPublicKeySpec)this.getKeySpec(key, class$de$flexiprovider$ec$keys$ECPublicKeySpec == null ? (class$de$flexiprovider$ec$keys$ECPublicKeySpec = ECKeyFactory.class$("de.flexiprovider.ec.keys.ECPublicKeySpec")) : class$de$flexiprovider$ec$keys$ECPublicKeySpec);
                return this.generatePublic(ecPubKeySpec);
            }
            if (key instanceof ECPrivateKey) {
                if (key instanceof ECPrivateKey) {
                    return key;
                }
                ECPrivateKeySpec ecPrivKeySpec = (ECPrivateKeySpec)this.getKeySpec(key, class$de$flexiprovider$ec$keys$ECPrivateKeySpec == null ? (class$de$flexiprovider$ec$keys$ECPrivateKeySpec = ECKeyFactory.class$("de.flexiprovider.ec.keys.ECPrivateKeySpec")) : class$de$flexiprovider$ec$keys$ECPrivateKeySpec);
                return this.generatePrivate(ecPrivKeySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

