/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.asn1;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OpenType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.asn1.OIDRegistry;
import codec.asn1.ResolverException;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.ec.asn1.ECurvesOIDRegistry;
import de.flexiprovider.ec.asn1.FieldId;
import de.flexiprovider.ec.asn1.PpBasis;
import de.flexiprovider.ec.asn1.TpBasis;
import java.util.ArrayList;

public class CharacteristicTwoField
extends ASN1Sequence {
    private ASN1ObjectIdentifier basisType;

    public CharacteristicTwoField() {
        super(3);
        this.basisType = new ASN1ObjectIdentifier();
        ((ArrayList)((Object)this)).add(new ASN1Integer());
        ((ArrayList)((Object)this)).add(this.basisType);
        ((ArrayList)((Object)this)).add(new ASN1OpenType((OIDRegistry)new ECurvesOIDRegistry(), this.basisType));
    }

    public CharacteristicTwoField(int n) {
        super(3);
        ((ArrayList)((Object)this)).add(new ASN1Integer(n));
        ((ArrayList)((Object)this)).add(FieldId.BASIS_TYPE_ONB);
        ((ArrayList)((Object)this)).add(new ASN1Null());
    }

    public CharacteristicTwoField(int n, int tc) {
        super(3);
        ((ArrayList)((Object)this)).add(new ASN1Integer(n));
        ((ArrayList)((Object)this)).add(FieldId.BASIS_TYPE_TRINOMIAL);
        ((ArrayList)((Object)this)).add(new TpBasis(tc));
    }

    public CharacteristicTwoField(int n, int pc1, int pc2, int pc3) {
        super(3);
        ((ArrayList)((Object)this)).add(new ASN1Integer(n));
        ((ArrayList)((Object)this)).add(FieldId.BASIS_TYPE_PENTANOMIAL);
        ((ArrayList)((Object)this)).add(new PpBasis(pc1, pc2, pc3));
    }

    public boolean isONB() {
        return ((ASN1ObjectIdentifier)((ArrayList)((Object)this)).get(1)).equals((Object)FieldId.BASIS_TYPE_ONB);
    }

    public boolean isTrinomial() {
        return ((ASN1ObjectIdentifier)((ArrayList)((Object)this)).get(1)).equals((Object)FieldId.BASIS_TYPE_TRINOMIAL);
    }

    public boolean isPentanomial() {
        return ((ASN1ObjectIdentifier)((ArrayList)((Object)this)).get(1)).equals((Object)FieldId.BASIS_TYPE_PENTANOMIAL);
    }

    public int getN() {
        return ASN1Tools.getFlexiBigInt((ASN1Integer)((ArrayList)((Object)this)).get(0)).intValue();
    }

    public TpBasis getTrinom() {
        ASN1Type type = (ASN1Type)((ArrayList)((Object)this)).get(2);
        if (type instanceof TpBasis) {
            return (TpBasis)type;
        }
        try {
            return (TpBasis)((ASN1OpenType)type).getInnerType();
        }
        catch (ResolverException re) {
            throw new RuntimeException("ResolverException: " + re.getMessage());
        }
    }

    public PpBasis getPenta() {
        ASN1Type type = (ASN1Type)((ArrayList)((Object)this)).get(2);
        if (type instanceof PpBasis) {
            return (PpBasis)type;
        }
        try {
            return (PpBasis)((ASN1OpenType)type).getInnerType();
        }
        catch (ResolverException re) {
            throw new RuntimeException("ResolverException: " + re.getMessage());
        }
    }
}

