/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.polynomials;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.common.math.polynomials.BinaryConvolutionPolynomial;
import de.flexiprovider.common.math.polynomials.ConvolutionPolynomial;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.common.util.IntUtils;

public class SparseBinaryConvolutionPolynomial
implements ConvolutionPolynomial {
    int N;
    int[] degrees;

    public SparseBinaryConvolutionPolynomial(int N, int[] degrees) {
        this.N = N;
        this.degrees = IntUtils.clone(degrees);
        IntUtils.quicksort(this.degrees);
    }

    public SparseBinaryConvolutionPolynomial(int N, int d, SecureRandom sr) {
        this.N = N <= 0 ? 1 : N;
        int degree = d;
        if (degree < 0) {
            degree = 0;
        }
        if (degree > N + 1) {
            degree = N + 1;
        }
        this.degrees = new int[degree];
        int[] index = new int[N];
        int i = N - 1;
        while (i >= 0) {
            index[i] = i;
            --i;
        }
        int k = N;
        int i2 = 0;
        while (i2 < d) {
            int n = sr.nextInt(k);
            this.degrees[i2] = index[n];
            index[n] = index[--k];
            ++i2;
        }
        IntUtils.quicksort(this.degrees);
    }

    public SparseBinaryConvolutionPolynomial(BinaryConvolutionPolynomial binPol) {
        this.N = binPol.N;
        this.degrees = new int[binPol.numCoeffs()];
        int index = this.degrees.length - 1;
        int i = this.N - 1;
        while (i >= 0) {
            if (binPol.testCoefficient(i)) {
                this.degrees[index] = i;
                --index;
            }
            --i;
        }
    }

    public SparseBinaryConvolutionPolynomial(SparseBinaryConvolutionPolynomial other) {
        this.N = other.N;
        this.degrees = IntUtils.clone(other.degrees);
    }

    private SparseBinaryConvolutionPolynomial(int N) {
        this.N = N;
    }

    int[][] getPatternLocations(int w) {
        int[][] locations = new int[w][(this.degrees.length + 1 >> 1) + 1];
        locations[0] = new int[this.degrees.length + 1];
        int currentPos = this.degrees.length - 1;
        while (currentPos > 0) {
            int dist = this.degrees[currentPos] - this.degrees[currentPos - 1];
            if (dist < w) {
                int[] nArray = locations[dist];
                int n = nArray[0];
                nArray[0] = n + 1;
                locations[dist][n + 1] = this.degrees[currentPos];
                currentPos -= 2;
                continue;
            }
            int[] nArray = locations[0];
            int n = nArray[0];
            nArray[0] = n + 1;
            locations[0][n + 1] = this.degrees[currentPos];
            --currentPos;
        }
        if (currentPos == 0) {
            int[] nArray = locations[0];
            int n = nArray[0];
            nArray[0] = n + 1;
            locations[0][n + 1] = this.degrees[0];
        }
        return locations;
    }

    public int[][] getPatterns() {
        int d = this.degrees.length;
        int[] numPatterns = new int[this.N - d + 1];
        int pos = d - 1;
        while (pos > 0) {
            int n = this.degrees[pos--] - this.degrees[pos--];
            numPatterns[n] = numPatterns[n] + 1;
        }
        int[][] L = new int[this.N - d + 1][];
        int currentPos = d - 1;
        while (currentPos > 0) {
            int dist = this.degrees[currentPos] - this.degrees[currentPos - 1];
            if (L[dist] == null) {
                L[dist] = new int[numPatterns[dist] + 1];
            }
            int[] nArray = L[dist];
            int n = nArray[0];
            nArray[0] = n + 1;
            L[dist][n + 1] = this.degrees[currentPos];
            currentPos -= 2;
        }
        if (currentPos == 0) {
            L[0] = new int[]{this.degrees[0]};
        }
        return L;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SparseBinaryConvolutionPolynomial)) {
            return false;
        }
        SparseBinaryConvolutionPolynomial otherPol = (SparseBinaryConvolutionPolynomial)other;
        return this.N == otherPol.N && IntUtils.equals(this.degrees, otherPol.degrees);
    }

    public int hashCode() {
        return this.N + this.degrees.hashCode();
    }

    public byte[] RE2OSP() {
        int oLen = IntegerFunctions.ceilLog256(this.N - 1);
        byte[] result = new byte[oLen * this.degrees.length];
        int i = 0;
        while (i < this.degrees.length) {
            byte[] os = BigEndianConversions.I2OSP(this.degrees[this.degrees.length - 1 - i], oLen);
            System.arraycopy(os, 0, result, i * oLen, oLen);
            ++i;
        }
        return result;
    }

    public static SparseBinaryConvolutionPolynomial OS2REP(int N, int d, byte[] encoded) throws IllegalArgumentException {
        int oLen = IntegerFunctions.ceilLog256(N - 1);
        if (encoded.length != oLen * d) {
            throw new IllegalArgumentException("Encoded sparse binary polynomial has wrong length.");
        }
        SparseBinaryConvolutionPolynomial result = new SparseBinaryConvolutionPolynomial(N);
        result.degrees = new int[d];
        int i = 0;
        while (i < d) {
            result.degrees[d - 1 - i] = BigEndianConversions.OS2IP(encoded, i * oLen, oLen);
            ++i;
        }
        return result;
    }

    public String toString() {
        int j;
        if (this.degrees.length == 0) {
            return "SparseBinaryConvolutionPolynomial (degree 0):\n0*x^0";
        }
        String result = "SparseBinaryConvolutionPolynomial (degree " + this.degrees[this.degrees.length - 1] + "):\n";
        result = result + "x^" + this.degrees[this.degrees.length - 1];
        int i = this.degrees.length - 2;
        while (i >= 0) {
            result = result + " + x^" + this.degrees[i];
            --i;
        }
        result = result + "\n";
        int i2 = this.degrees.length - 1;
        while (i2 >= 1) {
            result = result + "1";
            int numZeroes = this.degrees[i2] - this.degrees[i2 - 1] - 1;
            j = numZeroes - 1;
            while (j >= 0) {
                result = result + "0";
                --j;
            }
            --i2;
        }
        result = result + "1";
        j = this.degrees[0] - 1;
        while (j >= 0) {
            result = result + "0";
            --j;
        }
        return result;
    }
}

