/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.ies;

import de.flexiprovider.api.AsymmetricHybridCipher;
import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.KeyAgreement;
import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.Mac;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.IllegalBlockSizeException;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.ies.IESParameterSpec;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.kdf.KDF2;
import de.flexiprovider.core.kdf.KDFParameterSpec;
import java.io.ByteArrayOutputStream;

public abstract class IES
extends AsymmetricHybridCipher {
    protected SecureRandom random;
    private PublicKey pubKey;
    private PrivateKey privKey;
    private IESParameterSpec iesParams;
    private boolean isInternal = false;
    private String symCipherName;
    private BlockCipher symCipher;
    protected AlgorithmParameterSpec keyParams;
    private SecretKey symKey;
    private int symKeyLength;
    private String macName;
    private Mac mac;
    private SecretKeyFactory macKF;
    private int macLen;
    private byte[] macEncParams;
    private byte[] sharedData;
    private KeyAgreement kag;
    private KeyDerivation kdf;
    private PublicKey ephPubKey;
    private PrivateKey ephPrivKey;
    private int encEphPubKeySize;
    private int opMode;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();

    protected IES() {
        this.kag = this.getKeyAgreement();
        this.kdf = new KDF2();
    }

    public byte[] update(byte[] input, int inOff, int inLen) {
        if (input != null) {
            this.buf.write(input, inOff, inLen);
        }
        return new byte[0];
    }

    public byte[] doFinal(byte[] input, int inOff, int inLen) throws BadPaddingException {
        this.update(input, inOff, inLen);
        byte[] data = this.buf.toByteArray();
        this.buf.reset();
        if (this.opMode == 1) {
            return this.messageEncrypt(data);
        }
        if (this.opMode == 2) {
            return this.messageDecrypt(data);
        }
        return null;
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.pubKey = this.checkPubKey(key);
        this.iesParams = this.checkParameters(params);
        KeyPair ephKeyPair = this.iesParams.getEphKeyPair();
        if (ephKeyPair == null) {
            ephKeyPair = this.generateEphKeyPair();
            this.ephPubKey = ephKeyPair.getPublic();
            this.ephPrivKey = ephKeyPair.getPrivate();
        } else {
            this.ephPubKey = this.checkPubKey(ephKeyPair.getPublic());
            this.ephPrivKey = this.checkPrivKey(ephKeyPair.getPrivate());
        }
        this.encEphPubKeySize = this.getEncEphPubKeySize();
        this.symCipherName = this.iesParams.getSymCipherName();
        this.sharedData = this.iesParams.getSharedInfo();
        boolean bl = this.isInternal = this.symCipherName == null;
        if (!this.isInternal) {
            this.initSymCipher();
        }
        this.initMAC();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.opMode = 1;
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.privKey = this.checkPrivKey(key);
        this.iesParams = this.checkParameters(params);
        this.symCipherName = this.iesParams.getSymCipherName();
        this.sharedData = this.iesParams.getSharedInfo();
        boolean bl = this.isInternal = this.symCipherName == null;
        if (!this.isInternal) {
            this.initSymCipher();
        }
        this.encEphPubKeySize = this.getEncEphPubKeySize();
        this.initMAC();
        this.opMode = 2;
    }

    protected int decryptOutputSize(int inLen) {
        return 0;
    }

    protected int encryptOutputSize(int inLen) {
        return 0;
    }

    protected byte[] messageEncrypt(byte[] input) throws BadPaddingException {
        byte[] cText;
        byte[] keyStream = this.generateKeyStream(this.ephPrivKey, this.pubKey, input.length);
        try {
            cText = this.processMessage(keyStream, input);
        }
        catch (Exception e) {
            throw new BadPaddingException(e.getMessage());
        }
        byte[] macTag = this.generateMAC(keyStream, cText);
        return this.packCiphertext(cText, macTag);
    }

    protected byte[] messageDecrypt(byte[] input) throws BadPaddingException {
        byte[] cText;
        byte[] keyStream;
        byte[] newMacTag;
        byte[][] cm = this.unpackCiphertext(input);
        byte[] macTag = cm[1];
        if (!ByteUtils.equals(macTag, newMacTag = this.generateMAC(keyStream = this.generateKeyStream(this.privKey, this.ephPubKey, (cText = cm[0]).length), cText))) {
            throw new BadPaddingException("invalid ciphertext");
        }
        try {
            return this.processMessage(keyStream, cText);
        }
        catch (IllegalBlockSizeException e) {
            throw new BadPaddingException("invalid ciphertext");
        }
    }

    private IESParameterSpec checkParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            return new IESParameterSpec();
        }
        if (!(params instanceof IESParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        return (IESParameterSpec)params;
    }

    private void initSymCipher() {
        try {
            this.symCipher = Registry.getBlockCipher(this.symCipherName);
        }
        catch (Exception ex) {
            throw new RuntimeException("IES Init (checkSymCipher): " + ex.getMessage());
        }
        this.symKeyLength = this.iesParams.getSymKeyLength();
    }

    private void initMAC() {
        this.macName = this.iesParams.getMacName();
        try {
            this.mac = Registry.getMAC(this.macName);
            this.macKF = Registry.getSecretKeyFactory(this.iesParams.getMacKFName());
        }
        catch (Exception ex) {
            throw new RuntimeException("IES Init (checkMac): " + ex.getMessage());
        }
        this.macLen = this.mac.getMacLength();
        this.macEncParams = this.iesParams.getMacEncParam();
    }

    private byte[] generateKeyStream(PrivateKey privKey, PublicKey pubKey, int len) {
        int tLen = (this.isInternal ? len : this.symKeyLength) + this.macLen;
        try {
            this.kag.init(privKey, null, this.random);
            byte[] secretKey = this.kag.doPhase(pubKey, true).getEncoded();
            KDFParameterSpec kdfParams = new KDFParameterSpec(this.sharedData);
            this.kdf.init(secretKey, (AlgorithmParameterSpec)kdfParams);
            byte[] keyStream = this.kdf.deriveKey(tLen);
            if (!this.isInternal) {
                byte[] symKeyData = new byte[this.symKeyLength];
                System.arraycopy(keyStream, 0, symKeyData, 0, this.symKeyLength);
                SecretKeyFactory symKeyFactory = Registry.getSecretKeyFactory(this.iesParams.getSymKFName());
                SecretKeySpec keySpec = new SecretKeySpec(symKeyData, this.symCipherName);
                this.symKey = symKeyFactory.generateSecret(keySpec);
                if (this.opMode == 1) {
                    this.symCipher.initEncrypt(this.symKey, this.random);
                } else if (this.opMode == 2) {
                    this.symCipher.initDecrypt(this.symKey);
                }
            }
            return keyStream;
        }
        catch (Exception e) {
            throw new RuntimeException("internal error");
        }
    }

    private byte[] processMessage(byte[] keyStream, byte[] message) throws IllegalBlockSizeException, BadPaddingException {
        byte[] result;
        if (this.isInternal) {
            result = new byte[message.length];
            int i = message.length - 1;
            while (i >= 0) {
                result[i] = (byte)(message[i] ^ keyStream[i]);
                --i;
            }
        } else {
            result = this.symCipher.doFinal(message);
        }
        return result;
    }

    private byte[] generateMAC(byte[] keyStream, byte[] cText) {
        int macKeyLen = this.isInternal ? cText.length : this.symKeyLength;
        byte[] macKeyStream = new byte[keyStream.length - macKeyLen];
        System.arraycopy(keyStream, macKeyLen, macKeyStream, 0, macKeyStream.length);
        SecretKeySpec macKeySpec = new SecretKeySpec(macKeyStream, this.macName);
        try {
            SecretKey macKey = this.macKF.generateSecret(macKeySpec);
            this.mac.init(macKey);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("internal error");
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("InvalidKeyException: " + ike.getMessage());
        }
        macKeyLen = cText.length;
        byte[] macInput = cText;
        if (this.macEncParams != null) {
            macInput = new byte[macKeyLen + this.macEncParams.length];
            System.arraycopy(cText, 0, macInput, 0, macKeyLen);
            System.arraycopy(this.macEncParams, 0, macInput, macKeyLen, this.macEncParams.length);
        }
        byte[] macTag = this.mac.doFinal(macInput);
        return macTag;
    }

    private byte[] packCiphertext(byte[] cText, byte[] macTag) {
        byte[] result = new byte[this.encEphPubKeySize + cText.length + this.macLen];
        byte[] encEphPubKey = this.encodeEphPubKey(this.ephPubKey);
        System.arraycopy(encEphPubKey, 0, result, 0, this.encEphPubKeySize);
        System.arraycopy(cText, 0, result, this.encEphPubKeySize, cText.length);
        System.arraycopy(macTag, 0, result, this.encEphPubKeySize + cText.length, this.macLen);
        return result;
    }

    private byte[][] unpackCiphertext(byte[] input) {
        int cLen = input.length - this.encEphPubKeySize - this.macLen;
        byte[] encEphPubKey = new byte[this.encEphPubKeySize];
        byte[] cText = new byte[cLen];
        byte[] macTag = new byte[this.macLen];
        System.arraycopy(input, 0, encEphPubKey, 0, this.encEphPubKeySize);
        System.arraycopy(input, this.encEphPubKeySize, cText, 0, cLen);
        System.arraycopy(input, this.encEphPubKeySize + cLen, macTag, 0, this.macLen);
        this.ephPubKey = this.decodeEphPubKey(encEphPubKey);
        return new byte[][]{cText, macTag};
    }

    protected abstract PublicKey checkPubKey(Key var1) throws InvalidKeyException;

    protected abstract PrivateKey checkPrivKey(Key var1) throws InvalidKeyException;

    protected abstract KeyAgreement getKeyAgreement();

    protected abstract KeyPair generateEphKeyPair();

    protected abstract byte[] encodeEphPubKey(PublicKey var1);

    protected abstract int getEncEphPubKeySize();

    protected abstract PublicKey decodeEphPubKey(byte[] var1);
}

