/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rprimersa;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.mprsa.MpRSAPrivateKey;
import de.flexiprovider.core.mprsa.RSAOtherPrimeInfo;
import de.flexiprovider.core.rprimersa.RprimeRSAKeyGenParameterSpec;
import de.flexiprovider.core.rsa.RSAPublicKey;
import java.util.Vector;

public class RprimeRSAKeyPairGenerator
extends KeyPairGenerator {
    private static final int CERTAINTY = 80;
    private static final FlexiBigInt TWO = FlexiBigInt.valueOf(2L);
    private int keySize;
    private int k;
    private int s;
    private SecureRandom random;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom secureRand) throws InvalidAlgorithmParameterException {
        RprimeRSAKeyGenParameterSpec rsaParams;
        if (params == null) {
            rsaParams = new RprimeRSAKeyGenParameterSpec();
        } else if (params instanceof RprimeRSAKeyGenParameterSpec) {
            rsaParams = (RprimeRSAKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rsaParams.getKeySize();
        this.k = rsaParams.getNumPrimes();
        this.s = rsaParams.getPrivExpSize();
        this.random = secureRand != null ? secureRand : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom random) {
        RprimeRSAKeyGenParameterSpec params = new RprimeRSAKeyGenParameterSpec(keySize);
        try {
            this.initialize(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        RprimeRSAKeyGenParameterSpec defaultParams = new RprimeRSAKeyGenParameterSpec();
        try {
            this.initialize(defaultParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public KeyPair genKeyPair() {
        FlexiBigInt phi;
        FlexiBigInt d;
        int i;
        FlexiBigInt[] otherPrime;
        Vector<FlexiBigInt> v;
        FlexiBigInt q;
        FlexiBigInt p;
        FlexiBigInt n;
        int pBitSize;
        if (!this.initialized) {
            this.initializeDefault();
        }
        int qBitSize = pBitSize = (this.keySize + 1) / this.k;
        int rnBitSize = this.keySize - (this.k - 1) * pBitSize;
        do {
            p = new FlexiBigInt(pBitSize, 80, this.random);
            while (p.equals(q = new FlexiBigInt(qBitSize, 80, this.random)) || !p.subtract(FlexiBigInt.ONE).gcd(q.subtract(FlexiBigInt.ONE)).equals(TWO)) {
            }
            v = new Vector<FlexiBigInt>();
            v.addElement(p);
            v.addElement(q);
            otherPrime = new FlexiBigInt[this.k - 2];
            int i2 = 0;
            while (i2 < otherPrime.length - 1) {
                otherPrime[i2] = new FlexiBigInt(pBitSize, 80, this.random);
                if (this.contains(v, otherPrime[i2]) || !this.gcdIs2(otherPrime[i2], v)) {
                    --i2;
                } else {
                    v.addElement(otherPrime[i2]);
                }
                ++i2;
            }
            do {
                otherPrime[otherPrime.length - 1] = new FlexiBigInt(rnBitSize, 80, this.random);
            } while (this.contains(v, otherPrime[otherPrime.length - 1]) || !this.gcdIs2(otherPrime[otherPrime.length - 1], v));
            v.addElement(otherPrime[otherPrime.length - 1]);
            n = p.multiply(q);
            i = 0;
            while (i < otherPrime.length) {
                n = n.multiply(otherPrime[i]);
                ++i;
            }
        } while (n.bitLength() != this.keySize);
        FlexiBigInt[] pm = new FlexiBigInt[this.k];
        i = 0;
        while (i < this.k) {
            pm[i] = ((FlexiBigInt)v.elementAt(i)).subtract(FlexiBigInt.ONE);
            ++i;
        }
        FlexiBigInt[] dp = new FlexiBigInt[this.k];
        do {
            dp[0] = new FlexiBigInt(this.s, 80, this.random);
        } while (!dp[0].gcd(pm[0]).equals(FlexiBigInt.ONE));
        FlexiBigInt r = dp[0].mod(TWO);
        do {
            int i3 = 1;
            while (i3 < this.k) {
                do {
                    dp[i3] = new FlexiBigInt(this.s, 80, this.random);
                } while (!dp[i3].gcd(pm[i3]).equals(FlexiBigInt.ONE) || !dp[i3].mod(TWO).equals(r));
                ++i3;
            }
            FlexiBigInt[] ai = new FlexiBigInt[this.k];
            FlexiBigInt[] mi = new FlexiBigInt[this.k];
            FlexiBigInt m = FlexiBigInt.ONE;
            int i4 = 0;
            while (i4 < this.k) {
                ai[i4] = dp[i4].subtract(r).divide(TWO);
                mi[i4] = pm[i4].divide(TWO);
                m = m.multiply(mi[i4]);
                ++i4;
            }
            d = FlexiBigInt.ZERO;
            int i5 = 0;
            while (i5 < this.k) {
                FlexiBigInt Mi = m.divide(mi[i5]);
                FlexiBigInt y = Mi.modInverse(mi[i5]);
                d = d.add(y.multiply(Mi).multiply(ai[i5])).mod(m);
                ++i5;
            }
        } while (!(d = d.multiply(TWO).add(r)).gcd(phi = this.lcm(pm)).equals(FlexiBigInt.ONE));
        FlexiBigInt e_ = d.modInverse(phi);
        FlexiBigInt exponentOne = dp[0];
        FlexiBigInt exponentTwo = dp[1];
        FlexiBigInt crt = q.modInverse(p);
        RSAOtherPrimeInfo[] otherPrimeInfo = new RSAOtherPrimeInfo[this.k - 2];
        FlexiBigInt R = (FlexiBigInt)v.elementAt(0);
        int i6 = 0;
        while (i6 < otherPrimeInfo.length) {
            R = R.multiply((FlexiBigInt)v.elementAt(i6 + 1));
            otherPrimeInfo[i6] = new RSAOtherPrimeInfo(otherPrime[i6], dp[i6 + 2], R.modInverse(otherPrime[i6]));
            ++i6;
        }
        RSAPublicKey pubKey = new RSAPublicKey(n, e_);
        MpRSAPrivateKey privKey = new MpRSAPrivateKey(n, d, e_, p, q, exponentOne, exponentTwo, crt, otherPrimeInfo);
        return new KeyPair(pubKey, privKey);
    }

    private boolean contains(Vector v, FlexiBigInt x) {
        int i = 0;
        while (i < v.size()) {
            if (x.equals(v.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private FlexiBigInt lcm(FlexiBigInt[] v) {
        FlexiBigInt product;
        FlexiBigInt gcd_ = product = v[0];
        int i = 1;
        while (i < v.length) {
            FlexiBigInt tmp = v[i];
            product = product.multiply(tmp);
            gcd_ = gcd_.gcd(tmp);
            ++i;
        }
        return product.divide(gcd_);
    }

    private boolean gcdIs2(FlexiBigInt a, Vector v) {
        FlexiBigInt one = FlexiBigInt.ONE;
        FlexiBigInt tmp = a.subtract(one).gcd(((FlexiBigInt)v.elementAt(0)).subtract(one));
        boolean b = tmp.intValue() == 2;
        int i = 1;
        while (i < v.size() && b) {
            tmp = a.subtract(one).gcd(((FlexiBigInt)v.elementAt(i)).subtract(one));
            b = tmp.intValue() == 2;
            ++i;
        }
        return b;
    }
}

