/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc5;

import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.mode.ModeParameterSpec;
import de.flexiprovider.common.util.ByteUtils;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    public static final int RC5_v1_0 = 16;
    public static final int DEFAULT_NUM_ROUNDS = 12;
    public static final int DEFAULT_WORD_SIZE = 32;
    private int numRounds;
    private int wordSize;
    private byte[] iv;

    public RC5ParameterSpec() {
        this.numRounds = 12;
        this.wordSize = 32;
    }

    public RC5ParameterSpec(ModeParameterSpec modeParams) {
        this();
        this.iv = modeParams.getIV();
    }

    public RC5ParameterSpec(int numRounds, int wordSize) {
        this.numRounds = numRounds < 8 || numRounds > 127 ? 12 : numRounds;
        this.wordSize = wordSize != 16 && wordSize != 32 && wordSize != 64 ? 32 : wordSize;
    }

    public RC5ParameterSpec(int numRounds, int wordSize, ModeParameterSpec modeParams) {
        this(numRounds, wordSize);
        this.iv = modeParams.getIV();
    }

    public int getVersion() {
        return 16;
    }

    public int getNumRounds() {
        return this.numRounds;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public byte[] getIV() {
        return ByteUtils.clone(this.iv);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec otherSpec = (RC5ParameterSpec)other;
        return this.numRounds == otherSpec.numRounds && this.wordSize == otherSpec.wordSize && ByteUtils.equals(this.iv, otherSpec.iv);
    }

    public int hashCode() {
        int hash = 16 + this.numRounds + this.wordSize;
        if (this.iv != null) {
            hash += this.iv.hashCode();
        }
        return hash;
    }
}

