/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mersa;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.mersa.MeRSAKeyGenParameterSpec;
import de.flexiprovider.core.mersa.MeRSAPrivateKey;
import de.flexiprovider.core.rsa.RSAPublicKey;

public class MeRSAKeyPairGenerator
extends KeyPairGenerator {
    private final int CERTAINTY = 80;
    private static final FlexiBigInt TWO = FlexiBigInt.valueOf(2L);
    private int keySize;
    private FlexiBigInt e;
    private int k;
    private SecureRandom random;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        MeRSAKeyGenParameterSpec rsaParams;
        if (params == null) {
            rsaParams = new MeRSAKeyGenParameterSpec();
        } else if (params instanceof MeRSAKeyGenParameterSpec) {
            rsaParams = (MeRSAKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rsaParams.getKeySize();
        this.e = rsaParams.getE();
        this.k = rsaParams.getExponentK();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom secureRand) {
        MeRSAKeyGenParameterSpec params = new MeRSAKeyGenParameterSpec(keySize);
        try {
            this.initialize(params, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        MeRSAKeyGenParameterSpec defaultParams = new MeRSAKeyGenParameterSpec();
        try {
            this.initialize(defaultParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public KeyPair genKeyPair() {
        FlexiBigInt q;
        FlexiBigInt p;
        FlexiBigInt n;
        if (!this.initialized) {
            this.initializeDefault();
        }
        int pBitSize = this.keySize / (this.k + 1);
        int qBitSize = this.keySize - pBitSize * this.k;
        do {
            p = new FlexiBigInt(pBitSize, 80, this.random);
            while (p.equals(q = new FlexiBigInt(qBitSize, 80, this.random))) {
            }
        } while ((n = p.pow(this.k).multiply(q)).bitLength() != this.keySize);
        FlexiBigInt k_ = FlexiBigInt.valueOf(this.k);
        FlexiBigInt lcm = p.subtract(FlexiBigInt.ONE).multiply(q.subtract(FlexiBigInt.ONE));
        lcm = lcm.divide(p.subtract(FlexiBigInt.ONE).gcd(q.subtract(FlexiBigInt.ONE)));
        while (!this.e.gcd(p).equals(FlexiBigInt.ONE) || !this.e.gcd(lcm).equals(FlexiBigInt.ONE)) {
            this.e = this.e.add(TWO);
        }
        FlexiBigInt d = this.e.modInverse(lcm);
        FlexiBigInt dp = d.mod(p.subtract(FlexiBigInt.ONE));
        FlexiBigInt dq = d.mod(q.subtract(FlexiBigInt.ONE));
        FlexiBigInt e_inv_p = this.e.modInverse(p);
        FlexiBigInt pk_inv_q = p.pow(this.k).modInverse(q);
        RSAPublicKey pubKey = new RSAPublicKey(n, this.e);
        MeRSAPrivateKey privKey = new MeRSAPrivateKey(n, this.e, d, p, q, dp, dq, pk_inv_q, k_, e_inv_p);
        return new KeyPair(pubKey, privKey);
    }
}

