/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.md;

import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.IntegerFunctions;
import de.flexiprovider.common.util.FlexiBigIntUtils;
import java.util.Vector;

public class VSH
extends MessageDigest {
    public static final String ALG_NAME = "VSH";
    private byte[] buffer;
    private long count;
    private static final FlexiBigInt n = new FlexiBigInt("135066410865995223349603216278805969938881475605667027524485143851526510604859533833940287150571909441798207282164471551373680419703964191743046496589274256239341020864383202110372958725762358509643110564073501508187510676594629205563685529475213500852879416377328533906109750544334999811150056977236890927563");
    private int k;
    private static final int VSH_DIGEST_LENGTH = n.bitLength() + 7 >>> 3;
    private FlexiBigInt state;
    private Vector v;
    private int r;
    private byte[] arr = new byte[]{1, 8, 4, 8, 2, 8, 4, 8};
    private int b;

    public VSH() {
        this.k = this.computePrimes(n);
        this.r = this.k & 7;
        this.b = this.arr[this.r] * this.k >> 3;
        this.buffer = new byte[this.b];
        this.reset();
    }

    public int getDigestLength() {
        return VSH_DIGEST_LENGTH;
    }

    public synchronized void update(byte[] input, int offset, int len) {
        int bufOffset = (int)this.count % this.b;
        while (len > 0) {
            int copyLen = this.b - bufOffset;
            copyLen = len > copyLen ? copyLen : len;
            System.arraycopy(input, offset, this.buffer, bufOffset, copyLen);
            len -= copyLen;
            offset += copyLen;
            this.count += (long)copyLen;
            bufOffset = (bufOffset + copyLen) % this.b;
            if (bufOffset != 0) continue;
            this.processBlock(this.arr[this.r]);
        }
    }

    public synchronized void update(byte input) {
        this.buffer[(int)this.count % this.b] = input;
        if ((int)(this.count % (long)this.b) == this.b - 1) {
            this.processBlock(this.arr[this.r]);
        }
        ++this.count;
    }

    public synchronized void reset() {
        this.count = 0L;
        this.state = FlexiBigInt.ONE;
    }

    public synchronized byte[] digest() {
        this.pad();
        long bitLength = this.count << 3;
        Bitstring arrBitLength = new Bitstring(this.k, FlexiBigInt.valueOf(bitLength));
        FlexiBigInt p = FlexiBigInt.ONE;
        int i = 0;
        while (i < this.k) {
            p = p.multiply(((FlexiBigInt)this.v.elementAt(i + 1)).pow(arrBitLength.getBit(i))).mod(n);
            ++i;
        }
        FlexiBigInt result = this.state.multiply(this.state).mod(n).multiply(p).mod(n);
        byte[] digestValue = FlexiBigIntUtils.toMinimalByteArray(result);
        this.reset();
        return digestValue;
    }

    private int computePrimes(FlexiBigInt n) {
        FlexiBigInt prime = FlexiBigInt.ONE;
        FlexiBigInt primeProduct = FlexiBigInt.ONE;
        this.v = new Vector();
        this.v.addElement(FlexiBigInt.valueOf(-1L));
        while (n.max(primeProduct).equals(n)) {
            prime = IntegerFunctions.nextPrime(prime.longValue());
            primeProduct = primeProduct.multiply(prime);
            this.v.addElement(prime);
        }
        this.v.removeElementAt(this.v.size() - 1);
        return this.v.size() - 1;
    }

    private void pad() {
        long bitLength = this.count % (long)this.b << 3;
        if (bitLength != 0L) {
            int i = (int)this.count % this.b;
            while (i < this.b) {
                this.buffer[i] = 0;
                ++i;
            }
            int t = (int)((bitLength + (long)this.k - 1L) / (long)this.k);
            this.processBlock(t);
        }
    }

    private synchronized void processBlock(int t) {
        int length = this.buffer.length << 3;
        FlexiBigInt[] x_ = new FlexiBigInt[t + 1];
        Bitstring m = new Bitstring(length, this.buffer);
        x_[0] = this.state;
        int j = 0;
        while (j < t) {
            FlexiBigInt p = FlexiBigInt.ONE;
            int i = 0;
            while (i < this.k) {
                p = p.multiply(((FlexiBigInt)this.v.elementAt(i + 1)).pow(m.getBit(length - 1 - i - j * this.k))).mod(n);
                ++i;
            }
            x_[j + 1] = x_[j].multiply(x_[j]).mod(n).multiply(p).mod(n);
            ++j;
        }
        this.state = x_[t];
    }

    protected static class Bitstring {
        private int len;
        private int blocks;
        private int[] value;
        private static final int[] reverseRightMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
        private static final int[] bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE, 0};

        public Bitstring(int length, byte[] os) {
            int m;
            int l = length;
            if (l < 1) {
                l = 1;
            }
            this.blocks = (l - 1 >>> 5) + 1;
            this.value = new int[this.blocks];
            this.len = l;
            int k = Math.min((os.length - 1 >>> 2) + 1, this.blocks);
            int i = 0;
            while (i < k - 1) {
                m = os.length - (i << 2) - 1;
                this.value[i] = os[m] & 0xFF;
                int n = i;
                this.value[n] = this.value[n] | os[m - 1] << 8 & 0xFF00;
                int n2 = i;
                this.value[n2] = this.value[n2] | os[m - 2] << 16 & 0xFF0000;
                int n3 = i++;
                this.value[n3] = this.value[n3] | os[m - 3] << 24 & 0xFF000000;
            }
            i = k - 1;
            m = os.length - (i << 2) - 1;
            this.value[i] = os[m] & 0xFF;
            if (m > 0) {
                int n = i;
                this.value[n] = this.value[n] | os[m - 1] << 8 & 0xFF00;
            }
            if (m > 1) {
                int n = i;
                this.value[n] = this.value[n] | os[m - 2] << 16 & 0xFF0000;
            }
            if (m > 2) {
                int n = i;
                this.value[n] = this.value[n] | os[m - 3] << 24 & 0xFF000000;
            }
            if ((this.len & 0x1F) != 0) {
                int n = this.blocks - 1;
                this.value[n] = this.value[n] & reverseRightMask[this.len & 0x1F];
            }
            this.reduceN();
        }

        public Bitstring(int length, FlexiBigInt bi) {
            int l = length;
            if (l < 1) {
                l = 1;
            }
            this.blocks = (l - 1 >>> 5) + 1;
            this.value = new int[this.blocks];
            this.len = l;
            byte[] val = bi.toByteArray();
            if (val[0] == 0) {
                byte[] dummy = new byte[val.length - 1];
                System.arraycopy(val, 1, dummy, 0, dummy.length);
                val = dummy;
            }
            int ov = val.length & 3;
            int k = (val.length - 1 >>> 2) + 1;
            int i = 0;
            while (i < ov) {
                int n = k - 1;
                this.value[n] = this.value[n] | (val[i] & 0xFF) << (ov - 1 - i << 3);
                ++i;
            }
            int m = 0;
            i = 0;
            while (i <= val.length - 4 >> 2) {
                m = val.length - 1 - (i << 2);
                this.value[i] = val[m] & 0xFF;
                int n = i;
                this.value[n] = this.value[n] | val[m - 1] << 8 & 0xFF00;
                int n2 = i;
                this.value[n2] = this.value[n2] | val[m - 2] << 16 & 0xFF0000;
                int n3 = i++;
                this.value[n3] = this.value[n3] | val[m - 3] << 24 & 0xFF000000;
            }
            if ((this.len & 0x1F) != 0) {
                int n = this.blocks - 1;
                this.value[n] = this.value[n] & reverseRightMask[this.len & 0x1F];
            }
            this.reduceN();
        }

        public void reduceN() {
            int i = this.blocks - 1;
            while (this.value[i] == 0 && i > 0) {
                --i;
            }
            int h = this.value[i];
            int j = 0;
            while (h != 0) {
                h >>>= 1;
                ++j;
            }
            this.len = (i << 5) + j;
            this.blocks = i + 1;
        }

        public int getBit(int i) {
            if (i < 0 || i > this.len - 1) {
                return 0;
            }
            return (this.value[i >>> 5] & bitMask[i & 0x1F]) != 0 ? 1 : 0;
        }
    }
}

