/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.idea;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.idea.IDEAKey;

public class IDEA
extends BlockCipher {
    public static final String ALG_NAME = "IDEA";
    public static final String OID = "1.3.6.1.4.1.188.7.1.1";
    private static final int rounds = 8;
    private static final int keyLength = 52;
    private static final int mulModulus = 65537;
    private static final int mulMask = 65535;
    private static final int blockSize = 8;
    private static final int keySize = 16;
    private int[] encr = null;
    private int[] decr = null;

    protected IDEA(String modeName) {
        try {
            this.setMode(modeName);
        }
        catch (NoSuchModeException e) {
            throw new RuntimeException("Internal error: could not find mode '" + modeName + "'.");
        }
    }

    public IDEA() {
    }

    public String getName() {
        return ALG_NAME;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof IDEAKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a IDEA Key");
        }
        return 128;
    }

    protected int getCipherBlockSize() {
        return 8;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (key == null || !(key instanceof IDEAKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        this.encKeySchedule(key.getEncoded());
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, null);
        this.decKeySchedule();
    }

    protected void singleBlockEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.encryptDecrypt(this.encr, input, inOff, output, outOff);
    }

    protected void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        this.encryptDecrypt(this.decr, input, inOff, output, outOff);
    }

    private void encKeySchedule(byte[] keyBytes) {
        this.encr = new int[52];
        int i = 0;
        while (i < 8) {
            this.encr[i] = (keyBytes[i << 1] & 0xFF) << 8 | keyBytes[(i << 1) + 1] & 0xFF;
            ++i;
        }
        int j = 0;
        int koff = 0;
        while (i < 52) {
            this.encr[koff + ++j + 7] = (this.encr[koff + (j & 7)] << 9 | this.encr[koff + (j + 1 & 7)] >>> 7) & 0xFFFF;
            koff += j & 8;
            j &= 7;
            ++i;
        }
    }

    private void decKeySchedule() {
        this.decr = new int[52];
        int j = 0;
        this.decr[48] = this.mulInv(this.encr[j++]);
        this.decr[49] = -this.encr[j++];
        this.decr[50] = -this.encr[j++];
        this.decr[51] = this.mulInv(this.encr[j++]);
        int i = 42;
        while (i >= 0) {
            this.decr[i + 4] = this.encr[j++];
            this.decr[i + 5] = this.encr[j++];
            this.decr[i + 0] = this.mulInv(this.encr[j++]);
            if (i > 0) {
                this.decr[i + 2] = -this.encr[j++];
                this.decr[i + 1] = -this.encr[j++];
            } else {
                this.decr[i + 1] = -this.encr[j++];
                this.decr[i + 2] = -this.encr[j++];
            }
            this.decr[i + 3] = this.mulInv(this.encr[j++]);
            i -= 6;
        }
    }

    private void encryptDecrypt(int[] key, byte[] in, int in_offset, byte[] out, int out_offset) {
        int t0;
        int k = 0;
        int x0 = in[in_offset++] << 8;
        x0 |= in[in_offset++] & 0xFF;
        int x1 = in[in_offset++] << 8;
        x1 |= in[in_offset++] & 0xFF;
        int x2 = in[in_offset++] << 8;
        x2 |= in[in_offset++] & 0xFF;
        int x3 = in[in_offset++] << 8;
        x3 |= in[in_offset] & 0xFF;
        int i = 0;
        while (i < 8) {
            x0 = this.mulMod16(x0, key[k++]);
            x1 += key[k++];
            int n = k++;
            x3 = this.mulMod16(x3, key[k++]);
            t0 = x2 += key[n];
            x2 = this.mulMod16(x0 ^ x2, key[k++]);
            int t1 = x1;
            x1 = this.mulMod16((x1 ^ x3) + x2, key[k++]);
            x0 ^= x1;
            x3 ^= (x2 += x1);
            x1 ^= t0;
            x2 ^= t1;
            ++i;
        }
        x0 = this.mulMod16(x0, key[k++]);
        t0 = x1;
        x1 = x2 + key[k++];
        x2 = t0 + key[k++];
        x3 = this.mulMod16(x3, key[k]);
        out[out_offset++] = (byte)(x0 >>> 8);
        out[out_offset++] = (byte)x0;
        out[out_offset++] = (byte)(x1 >>> 8);
        out[out_offset++] = (byte)x1;
        out[out_offset++] = (byte)(x2 >>> 8);
        out[out_offset++] = (byte)x2;
        out[out_offset++] = (byte)(x3 >>> 8);
        out[out_offset] = (byte)x3;
    }

    private int mulInv(int x) {
        if ((x &= 0xFFFF) <= 1) {
            return x;
        }
        int t1 = (int)(65537L / (long)x);
        int y = (int)(65537L % (long)x);
        if (y == 1) {
            return 1 - t1 & 0xFFFF;
        }
        int t0 = 1;
        do {
            int q = x / y;
            t0 = t0 + q * t1 & 0xFFFF;
            if ((x %= y) == 1) {
                return t0;
            }
            q = y / x;
            t1 = t1 + q * t0 & 0xFFFF;
        } while ((y %= x) != 1);
        return 1 - t1 & 0xFFFF;
    }

    private int mulMod16(int a, int b) {
        int p;
        b &= 0xFFFF;
        a = (a &= 0xFFFF) == 0 ? 65537 - b : (b == 0 ? 65537 - a : b - a + ((b = (p = a * b) & 0xFFFF) < (a = p >>> 16) ? 1 : 0));
        return a & 0xFFFF;
    }

    public static class IDEA_OFB
    extends IDEA {
        public static final String OID = "1.3.6.1.4.1.188.7.1.1.4";

        public IDEA_OFB() {
            super("OFB");
        }
    }

    public static class IDEA_CFB
    extends IDEA {
        public static final String OID = "1.3.6.1.4.1.188.7.1.1.3";

        public IDEA_CFB() {
            super("CFB");
        }
    }

    public static class IDEA_CBC
    extends IDEA {
        public static final String OID = "1.3.6.1.4.1.188.7.1.1.2";

        public IDEA_CBC() {
            super("CBC");
        }
    }

    public static class IDEA_ECB
    extends IDEA {
        public static final String OID = "1.3.6.1.4.1.188.7.1.1.1";

        public IDEA_ECB() {
            super("ECB");
        }
    }
}

