/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.SignatureException;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.dsa.interfaces.DSAParams;
import de.flexiprovider.core.dsa.interfaces.DSAPrivateKey;
import de.flexiprovider.core.dsa.interfaces.DSAPublicKey;
import de.flexiprovider.core.md.NullDigest;
import java.io.IOException;
import java.util.ArrayList;

public abstract class DSASignature
extends de.flexiprovider.core.dsa.interfaces.DSASignature {
    private DSAPublicKey pubKey;
    private DSAPrivateKey privKey;
    private SecureRandom random;
    private MessageDigest md;
    private FlexiBigInt p;
    private FlexiBigInt q;
    private FlexiBigInt g;
    private int N;

    protected DSASignature(MessageDigest md) {
        this.md = md;
    }

    public void initSign(PrivateKey privKey, SecureRandom random) throws InvalidKeyException {
        if (!(privKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        this.privKey = (DSAPrivateKey)privKey;
        DSAParams dsaParams = this.privKey.getParameters();
        this.p = dsaParams.getPrimeP();
        this.q = dsaParams.getPrimeQ();
        this.g = dsaParams.getBaseG();
        this.N = this.q.bitLength();
        this.random = random == null ? Registry.getSecureRandom() : random;
    }

    public void initVerify(PublicKey pubKey) throws InvalidKeyException {
        if (!(pubKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        this.pubKey = (DSAPublicKey)pubKey;
        DSAParams dsaParams = this.pubKey.getParameters();
        this.p = dsaParams.getPrimeP();
        this.g = dsaParams.getBaseG();
        this.q = dsaParams.getPrimeQ();
        this.N = this.q.bitLength();
    }

    public void setParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            if (!(params instanceof DSAParams)) {
                throw new InvalidAlgorithmParameterException("unsupported type");
            }
            DSAParams dsaParams = (DSAParams)((Object)params);
            this.p = dsaParams.getPrimeP();
            this.q = dsaParams.getPrimeQ();
            this.g = dsaParams.getBaseG();
        }
    }

    public void update(byte b) {
        this.md.update(b);
    }

    public void update(byte[] b, int offset, int length) {
        this.md.update(b, offset, length);
    }

    public byte[] sign() throws SignatureException {
        FlexiBigInt k;
        FlexiBigInt m = this.computeMessageRepresentative();
        while ((k = new FlexiBigInt(this.N, this.random)).compareTo(FlexiBigInt.ONE) <= 0 || k.compareTo(this.q) >= 0) {
        }
        FlexiBigInt kInv = k.modInverse(this.q);
        FlexiBigInt x = this.privKey.getValueX();
        FlexiBigInt r = this.g.modPow(k, this.p).mod(this.q);
        FlexiBigInt s = kInv.multiply(m.add(x.multiply(r))).mod(this.q);
        DSAASN1Signature sig = new DSAASN1Signature(r, s);
        try {
            return ASN1Tools.derEncode((ASN1Type)sig);
        }
        catch (RuntimeException re) {
            throw new SignatureException(re.getMessage());
        }
    }

    public boolean verify(byte[] sigBytes) {
        DSAASN1Signature sig = new DSAASN1Signature();
        try {
            ASN1Tools.derDecode(sigBytes, (ASN1Type)sig);
        }
        catch (ASN1Exception ae) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        FlexiBigInt m = this.computeMessageRepresentative();
        FlexiBigInt r = sig.getR();
        FlexiBigInt s = sig.getS();
        FlexiBigInt y = this.pubKey.getValueY();
        if (r.compareTo(this.q) >= 0 || s.compareTo(this.q) >= 0) {
            return false;
        }
        FlexiBigInt w = s.modInverse(this.q);
        FlexiBigInt u1 = m.multiply(w).mod(this.q);
        FlexiBigInt u2 = r.multiply(w).mod(this.q);
        FlexiBigInt v = this.g.modPow(u1, this.p).multiply(y.modPow(u2, this.p)).mod(this.p).mod(this.q);
        return r.compareTo(v) == 0;
    }

    private FlexiBigInt computeMessageRepresentative() {
        byte[] hash = this.md.digest();
        FlexiBigInt m = new FlexiBigInt(1, hash);
        int hLen = this.md.getDigestLength();
        int trunc = 8 * hLen - this.N;
        if (trunc > 0) {
            m = m.shiftRight(trunc);
        }
        return m;
    }

    private static class DSAASN1Signature
    extends ASN1Sequence {
        private ASN1Integer r;
        private ASN1Integer s;

        public DSAASN1Signature() {
            super(2);
            this.r = new ASN1Integer();
            this.s = new ASN1Integer();
            ((ArrayList)((Object)this)).add(this.r);
            ((ArrayList)((Object)this)).add(this.s);
        }

        public DSAASN1Signature(FlexiBigInt r, FlexiBigInt s) {
            super(2);
            this.r = ASN1Tools.createInteger(r);
            this.s = ASN1Tools.createInteger(s);
            ((ArrayList)((Object)this)).add(this.r);
            ((ArrayList)((Object)this)).add(this.s);
        }

        public FlexiBigInt getR() {
            return ASN1Tools.getFlexiBigInt(this.r);
        }

        public FlexiBigInt getS() {
            return ASN1Tools.getFlexiBigInt(this.s);
        }
    }

    public static class Raw
    extends DSASignature {
        public Raw() {
            super(new NullDigest());
        }
    }

    public static class SHA512
    extends DSASignature {
        public SHA512() {
            super(new de.flexiprovider.core.md.SHA512());
        }
    }

    public static class SHA384
    extends DSASignature {
        public SHA384() {
            super(new de.flexiprovider.core.md.SHA384());
        }
    }

    public static class SHA256
    extends DSASignature {
        public SHA256() {
            super(new de.flexiprovider.core.md.SHA256());
        }
    }

    public static class SHA224
    extends DSASignature {
        public SHA224() {
            super(new de.flexiprovider.core.md.SHA224());
        }
    }

    public static class SHA1
    extends DSASignature {
        public static final String OID = "1.2.840.10040.4.3";
        public static final String OID2 = "1.3.14.3.2.13";
        public static final String OID3 = "1.3.14.3.2.27";

        public SHA1() {
            super(new de.flexiprovider.core.md.SHA1());
        }
    }
}

