/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.dsa;

import codec.CorruptedCodeException;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Type;
import codec.pkcs8.PrivateKeyInfo;
import codec.x509.SubjectPublicKeyInfo;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.KeySpec;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.dsa.DSAParameterSpec;
import de.flexiprovider.core.dsa.DSAPrivateKey;
import de.flexiprovider.core.dsa.DSAPrivateKeySpec;
import de.flexiprovider.core.dsa.DSAPublicKey;
import de.flexiprovider.core.dsa.DSAPublicKeySpec;
import de.flexiprovider.core.dsa.interfaces.DSAParams;
import de.flexiprovider.pki.AlgorithmIdentifier;
import de.flexiprovider.pki.PKCS8EncodedKeySpec;
import de.flexiprovider.pki.PKITools;
import de.flexiprovider.pki.X509EncodedKeySpec;

public class DSAKeyFactory
extends de.flexiprovider.core.dsa.interfaces.DSAKeyFactory {
    public static final String OID = "1.2.840.10040.4.1";
    public static final String OID2 = "1.3.14.3.2.12";
    static /* synthetic */ Class class$de$flexiprovider$core$dsa$DSAParameterSpec;
    static /* synthetic */ Class class$de$flexiprovider$pki$X509EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$dsa$DSAPublicKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$pki$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$de$flexiprovider$core$dsa$DSAPrivateKeySpec;

    public PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            return new DSAPrivateKey((DSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] encKey = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            PrivateKeyInfo pki = new PrivateKeyInfo();
            try {
                ASN1Tools.derDecode(encKey, (ASN1Type)pki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
            ASN1Integer key = null;
            try {
                key = (ASN1Integer)pki.getDecodedRawKey();
            }
            catch (CorruptedCodeException CCExc) {
                throw new InvalidKeySpecException(CCExc.getMessage());
            }
            FlexiBigInt y = ASN1Tools.getFlexiBigInt(key);
            AlgorithmIdentifier algId = PKITools.getAlgorithmIdentifier(pki);
            AlgorithmParameters aparam = null;
            try {
                aparam = algId.getParams();
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
            DSAParameterSpec dsaps = null;
            try {
                dsaps = (DSAParameterSpec)aparam.getParameterSpec(class$de$flexiprovider$core$dsa$DSAParameterSpec == null ? (class$de$flexiprovider$core$dsa$DSAParameterSpec = DSAKeyFactory.class$("de.flexiprovider.core.dsa.DSAParameterSpec")) : class$de$flexiprovider$core$dsa$DSAParameterSpec);
            }
            catch (InvalidParameterSpecException IPSExc) {
                throw new InvalidKeySpecException("InvalidParameterSpecException: " + IPSExc.getMessage());
            }
            DSAParameterSpec params = dsaps;
            return new DSAPrivateKey(y, params);
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec + ".");
    }

    public PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            return new DSAPublicKey((DSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo();
            try {
                ASN1Tools.derDecode(enc, (ASN1Type)spki);
            }
            catch (Exception ce) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec.");
            }
            ASN1Type key = null;
            try {
                key = spki.getDecodedRawKey();
            }
            catch (CorruptedCodeException CCExc) {
                throw new InvalidKeySpecException(CCExc.getMessage());
            }
            FlexiBigInt x = ASN1Tools.getFlexiBigInt((ASN1Integer)key);
            AlgorithmIdentifier algId = PKITools.getAlgorithmIdentifier(spki);
            AlgorithmParameters aparam = null;
            try {
                aparam = algId.getParams();
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
            DSAParameterSpec dsaps = null;
            try {
                dsaps = (DSAParameterSpec)aparam.getParameterSpec(class$de$flexiprovider$core$dsa$DSAParameterSpec == null ? (class$de$flexiprovider$core$dsa$DSAParameterSpec = DSAKeyFactory.class$("de.flexiprovider.core.dsa.DSAParameterSpec")) : class$de$flexiprovider$core$dsa$DSAParameterSpec);
            }
            catch (InvalidParameterSpecException IPSExc) {
                throw new InvalidKeySpecException("InvalidParameterSpecException: " + IPSExc.getMessage());
            }
            DSAParameterSpec params = dsaps;
            return new DSAPublicKey(x, params);
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec + ".");
    }

    public KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof DSAPublicKey) {
            if ((class$de$flexiprovider$pki$X509EncodedKeySpec == null ? (class$de$flexiprovider$pki$X509EncodedKeySpec = DSAKeyFactory.class$("de.flexiprovider.pki.X509EncodedKeySpec")) : class$de$flexiprovider$pki$X509EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$core$dsa$DSAPublicKeySpec == null ? (class$de$flexiprovider$core$dsa$DSAPublicKeySpec = DSAKeyFactory.class$("de.flexiprovider.core.dsa.DSAPublicKeySpec")) : class$de$flexiprovider$core$dsa$DSAPublicKeySpec).isAssignableFrom(keySpec)) {
                DSAPublicKey dsaPubKey = (DSAPublicKey)key;
                DSAParams params = dsaPubKey.getParameters();
                return new DSAPublicKeySpec(dsaPubKey.getValueY(), params.getPrimeP(), params.getPrimeQ(), params.getBaseG());
            }
        } else if (key instanceof DSAPrivateKey) {
            if ((class$de$flexiprovider$pki$PKCS8EncodedKeySpec == null ? (class$de$flexiprovider$pki$PKCS8EncodedKeySpec = DSAKeyFactory.class$("de.flexiprovider.pki.PKCS8EncodedKeySpec")) : class$de$flexiprovider$pki$PKCS8EncodedKeySpec).isAssignableFrom(keySpec)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if ((class$de$flexiprovider$core$dsa$DSAPrivateKeySpec == null ? (class$de$flexiprovider$core$dsa$DSAPrivateKeySpec = DSAKeyFactory.class$("de.flexiprovider.core.dsa.DSAPrivateKeySpec")) : class$de$flexiprovider$core$dsa$DSAPrivateKeySpec).isAssignableFrom(keySpec)) {
                DSAPrivateKey dsaPrivateKey = (DSAPrivateKey)key;
                DSAParams params = dsaPrivateKey.getParameters();
                return new DSAPrivateKeySpec(dsaPrivateKey.getValueX(), params.getPrimeP(), params.getPrimeQ(), params.getBaseG());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + keySpec + ".");
    }

    public Key translateKey(Key key) throws InvalidKeyException {
        if (key instanceof DSAPrivateKey) {
            if (key instanceof DSAPrivateKey) {
                return key;
            }
            DSAPrivateKey dsaKey = (DSAPrivateKey)key;
            return new DSAPrivateKey(dsaKey.getValueX(), dsaKey.getParameters());
        }
        if (key instanceof DSAPublicKey) {
            if (key instanceof DSAPublicKey) {
                return key;
            }
            DSAPublicKey dsaKey = (DSAPublicKey)key;
            return new DSAPublicKey(dsaKey.getValueY(), dsaKey.getParameters());
        }
        throw new InvalidKeyException("Unsupported key type: " + key.getClass() + ".");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

