/*
 * Decompiled with CFR 0.152.
 */
package codec.util;

import codec.util.CertificateSource;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;

public class CertificateChainVerifier {
    private CertificateSource trusted_;

    public CertificateChainVerifier(CertificateSource trusted) {
        if (trusted == null) {
            throw new NullPointerException("Trusted cert source");
        }
        this.trusted_ = trusted;
    }

    public void verify(X509Certificate cert, CertificateSource other) throws GeneralSecurityException {
        if (cert == null) {
            throw new NullPointerException("Certificate");
        }
        HashSet verified = new HashSet(8);
        X509Certificate origCert = cert;
        cert.checkValidity();
        int chainLength = 0;
        while (true) {
            if (verified.contains(cert)) {
                throw new CertificateException("Circular chain!");
            }
            X509Certificate issuerCert = this.checkIssuer(cert, this.trusted_, chainLength);
            if (issuerCert != null) {
                return;
            }
            issuerCert = this.checkIssuer(cert, other, chainLength);
            if (issuerCert == null) {
                this.fail("Untrusted certificate: %s", origCert);
            }
            cert = issuerCert;
            ++chainLength;
        }
    }

    public void verify(X509Certificate cert) throws GeneralSecurityException {
        if (cert == null) {
            throw new NullPointerException("Certificate");
        }
        cert.checkValidity();
        if (this.checkIssuer(cert, this.trusted_, 0) == null) {
            this.fail("Untrusted certificate: %s", cert);
        }
    }

    public void verifyChain(X509Certificate[] chain) throws GeneralSecurityException {
        if (chain == null) {
            throw new NullPointerException("Chain");
        }
        if (chain.length < 1 || chain[0] == null) {
            throw new CertificateException("Chain is empty or element 0 is null!");
        }
        X509Certificate cert = chain[0];
        cert.checkValidity();
        if (this.isTrusted(cert)) {
            return;
        }
        int n = 1;
        while (n < chain.length) {
            int maxChainLength;
            X509Certificate issuerCert = chain[n];
            if (issuerCert == null) {
                throw new CertificateException("Null cert at " + n);
            }
            issuerCert.checkValidity();
            boolean[] usage = issuerCert.getKeyUsage();
            if (usage == null || usage.length < 6 || !usage[5]) {
                this.fail("Not a key signing certificate: %s", issuerCert);
            }
            if ((maxChainLength = issuerCert.getBasicConstraints()) < 0) {
                this.fail("Chain contains non CA cert: %s", issuerCert);
            }
            if (maxChainLength + 1 < n) {
                this.fail("Chain too long at %s", issuerCert);
            }
            if (!cert.getIssuerDN().equals(issuerCert.getSubjectDN())) {
                this.fail("Issuer vs. subject mismatch in cert: %s", cert);
            }
            cert.verify(issuerCert.getPublicKey());
            if (this.isTrusted(issuerCert)) {
                return;
            }
            ++n;
        }
        this.fail("Chain of %s is not trusted!", chain[0]);
    }

    public boolean isTrusted(X509Certificate cert) {
        if (cert == null) {
            return false;
        }
        X509Certificate trustedCert = this.trusted_.getCertificate(cert.getIssuerDN(), cert.getSerialNumber());
        if (trustedCert == null) {
            return false;
        }
        return trustedCert.equals(cert);
    }

    private X509Certificate checkIssuer(X509Certificate cert, CertificateSource certSource, int chainLength) throws GeneralSecurityException {
        Iterator i = certSource.certificates(cert.getIssuerDN(), 32);
        while (i.hasNext()) {
            X509Certificate issuerCert = (X509Certificate)i.next();
            try {
                issuerCert.checkValidity();
            }
            catch (CertificateException e) {
                System.err.println("Warning, trusted cert is not current:\n" + issuerCert);
                continue;
            }
            try {
                cert.verify(issuerCert.getPublicKey());
            }
            catch (InvalidKeyException e) {
                continue;
            }
            int maxChainLength = issuerCert.getBasicConstraints();
            if (maxChainLength < 0) {
                this.fail("Trusted cert is not a CA cert: %s", issuerCert);
            }
            if (maxChainLength < chainLength) {
                this.fail("Certificate chain too long (" + maxChainLength + " > " + chainLength + ") at %s", issuerCert);
            }
            return issuerCert;
        }
        return null;
    }

    private void fail(String message, X509Certificate cert) throws CertificateException {
        int n = message.indexOf("%s");
        if (n >= 0) {
            message = message.substring(0, n) + "issuer=\"" + cert.getIssuerDN().getName() + "\", serial=" + cert.getSerialNumber() + message.substring(n + 2);
        }
        throw new CertificateException(message);
    }
}

