/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.InconsistentStateException;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.DEREncoder;
import codec.asn1.Encoder;
import codec.asn1.OIDRegistry;
import codec.pkcs9.Attributes;
import codec.util.JCA;
import codec.x501.Attribute;
import codec.x501.BadNameException;
import codec.x501.Name;
import codec.x509.AlgorithmIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class SignerInfo
extends ASN1Sequence {
    protected ASN1Integer version_ = new ASN1Integer(1);
    protected Name issuer_;
    protected ASN1Integer serial_;
    protected AlgorithmIdentifier dAlg_;
    protected AlgorithmIdentifier cAlg_;
    protected Attributes auth_;
    protected Attributes attr_;
    protected ASN1OctetString edig_;
    protected String algorithm_;
    protected AlgorithmParameterSpec spec_;
    private boolean strict = false;
    static /* synthetic */ Class class$java$security$spec$AlgorithmParameterSpec;

    public SignerInfo() {
        super(7);
        this.add(this.version_);
        this.issuer_ = new Name();
        this.serial_ = new ASN1Integer();
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        this.dAlg_ = new AlgorithmIdentifier();
        this.add(this.dAlg_);
        this.auth_ = new Attributes();
        this.add(new ASN1TaggedType(0, this.auth_, false, true));
        this.cAlg_ = new AlgorithmIdentifier();
        this.add(this.cAlg_);
        this.edig_ = new ASN1OctetString();
        this.add(this.edig_);
        this.attr_ = new Attributes();
        this.add(new ASN1TaggedType(1, this.attr_, false, true));
    }

    public SignerInfo(OIDRegistry registry) {
        super(7);
        this.add(this.version_);
        this.issuer_ = new Name();
        this.serial_ = new ASN1Integer();
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        this.dAlg_ = new AlgorithmIdentifier();
        this.add(this.dAlg_);
        this.auth_ = new Attributes(registry);
        this.add(new ASN1TaggedType(0, this.auth_, false, true));
        this.cAlg_ = new AlgorithmIdentifier();
        this.add(this.cAlg_);
        this.edig_ = new ASN1OctetString();
        this.add(this.edig_);
        this.attr_ = new Attributes(registry);
        this.add(new ASN1TaggedType(1, this.attr_, false, true));
    }

    public SignerInfo(X509Certificate cert, String algorithm) throws BadNameException, NoSuchAlgorithmException {
        super(7);
        this.add(this.version_);
        this.issuer_ = new Name(cert.getIssuerDN().getName(), -1);
        this.serial_ = new ASN1Integer(cert.getSerialNumber());
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        String d = JCA.getDigestOID(algorithm);
        String c = JCA.getCipherOID(algorithm);
        if (d == null || c == null) {
            throw new NoSuchAlgorithmException("Cannot resolve signature algorithm!");
        }
        try {
            this.dAlg_ = new AlgorithmIdentifier(new ASN1ObjectIdentifier(d), new ASN1Null());
            this.cAlg_ = new AlgorithmIdentifier(new ASN1ObjectIdentifier(c), new ASN1Null());
        }
        catch (ASN1Exception e) {
            throw new InconsistentStateException(e);
        }
        this.add(this.dAlg_);
        this.auth_ = new Attributes();
        this.add(new ASN1TaggedType(0, this.auth_, false, true));
        this.add(this.cAlg_);
        this.edig_ = new ASN1OctetString();
        this.add(this.edig_);
        this.attr_ = new Attributes();
        this.add(new ASN1TaggedType(1, this.attr_, false, true));
        this.algorithm_ = algorithm;
    }

    public SignerInfo(X509Certificate cert, String algorithm, int nameEncoding) throws BadNameException, NoSuchAlgorithmException {
        super(7);
        this.add(this.version_);
        this.issuer_ = new Name(cert.getIssuerDN().getName(), nameEncoding);
        this.serial_ = new ASN1Integer(cert.getSerialNumber());
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        String d = JCA.getDigestOID(algorithm);
        String c = JCA.getCipherOID(algorithm);
        if (d == null || c == null) {
            throw new NoSuchAlgorithmException("Cannot resolve signature algorithm!");
        }
        try {
            this.dAlg_ = new AlgorithmIdentifier(new ASN1ObjectIdentifier(d), new ASN1Null());
            this.cAlg_ = new AlgorithmIdentifier(new ASN1ObjectIdentifier(c), new ASN1Null());
        }
        catch (ASN1Exception e) {
            throw new InconsistentStateException(e);
        }
        this.add(this.dAlg_);
        this.auth_ = new Attributes();
        this.add(new ASN1TaggedType(0, this.auth_, false, true));
        this.add(this.cAlg_);
        this.edig_ = new ASN1OctetString();
        this.add(this.edig_);
        this.attr_ = new Attributes();
        this.add(new ASN1TaggedType(1, this.attr_, false, true));
        this.algorithm_ = algorithm;
    }

    public SignerInfo(X509Certificate cert, String algorithm, AlgorithmParameters params) throws BadNameException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(7);
        this.add(this.version_);
        this.issuer_ = new Name(cert.getIssuerDN().getName(), -1);
        this.serial_ = new ASN1Integer(cert.getSerialNumber());
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        String s = JCA.getOID(algorithm);
        if (s == null) {
            throw new NoSuchAlgorithmException("Cannot resolve signature algorithm!");
        }
        this.dAlg_ = new AlgorithmIdentifier(s, params);
        this.cAlg_ = new AlgorithmIdentifier(s);
        this.add(this.dAlg_);
        this.auth_ = new Attributes();
        this.add(new ASN1TaggedType(0, this.auth_, false, true));
        this.add(this.cAlg_);
        this.edig_ = new ASN1OctetString();
        this.add(this.edig_);
        this.attr_ = new Attributes();
        this.add(new ASN1TaggedType(1, this.attr_, false, true));
        this.algorithm_ = algorithm;
        if (params != null) {
            try {
                this.spec_ = params.getParameterSpec(class$java$security$spec$AlgorithmParameterSpec == null ? (class$java$security$spec$AlgorithmParameterSpec = SignerInfo.class$("java.security.spec.AlgorithmParameterSpec")) : class$java$security$spec$AlgorithmParameterSpec);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Cannot transform params to spec!");
            }
        }
    }

    public SignerInfo(X509Certificate cert, String algorithm, AlgorithmParameters params, int nameEncoding) throws BadNameException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(7);
        this.add(this.version_);
        this.issuer_ = new Name(cert.getIssuerDN().getName(), nameEncoding);
        this.serial_ = new ASN1Integer(cert.getSerialNumber());
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(this.issuer_);
        seq.add(this.serial_);
        this.add(seq);
        String s = JCA.getOID(algorithm);
        if (s == null) {
            throw new NoSuchAlgorithmException("Cannot resolve signature algorithm!");
        }
        this.dAlg_ = new AlgorithmIdentifier(s, params);
        this.cAlg_ = new AlgorithmIdentifier(s);
        this.add(this.dAlg_);
        this.auth_ = new Attributes();
        this.add(new ASN1TaggedType(0, this.auth_, false, true));
        this.add(this.cAlg_);
        this.edig_ = new ASN1OctetString();
        this.add(this.edig_);
        this.attr_ = new Attributes();
        this.add(new ASN1TaggedType(1, this.attr_, false, true));
        this.algorithm_ = algorithm;
        if (params != null) {
            try {
                this.spec_ = params.getParameterSpec(class$java$security$spec$AlgorithmParameterSpec == null ? (class$java$security$spec$AlgorithmParameterSpec = SignerInfo.class$("java.security.spec.AlgorithmParameterSpec")) : class$java$security$spec$AlgorithmParameterSpec);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Cannot transform params to spec!");
            }
        }
    }

    public void setStrict(boolean strictness) {
        this.strict = strictness;
    }

    public void update(Signature sig) throws SignatureException {
        if (sig == null) {
            throw new NullPointerException("Sig is null!");
        }
        if (this.auth_.size() > 0) {
            try {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DEREncoder enc = new DEREncoder(bos);
                    if (this.strict) {
                        enc.setStrict(true);
                    }
                    this.auth_.setExplicit(true);
                    this.auth_.encode(enc);
                    sig.update(bos.toByteArray());
                    enc.close();
                }
                catch (ASN1Exception e) {
                    throw new InconsistentStateException(e);
                }
                catch (IOException e) {
                    throw new InconsistentStateException(e);
                }
                Object var7_4 = null;
                this.auth_.setExplicit(false);
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                this.auth_.setExplicit(false);
                throw throwable;
            }
        }
    }

    public void setEncryptedDigest(byte[] edig) {
        this.edig_ = new ASN1OctetString(edig);
        this.set(5, this.edig_);
    }

    public byte[] getEncryptedDigest() {
        return this.edig_.getByteArray();
    }

    public Attributes authenticatedAttributes() {
        return this.auth_;
    }

    public void addAuthenticatedAttribute(Attribute attr) {
        if (attr == null) {
            throw new NullPointerException("Need an attribute!");
        }
        this.auth_.add(attr);
    }

    public Attributes unauthenticatedAttributes() {
        return this.attr_;
    }

    public void addUnauthenticatedAttribute(Attribute attr) {
        if (attr == null) {
            throw new NullPointerException("Need an attribute!");
        }
        this.attr_.add(attr);
    }

    public Principal getIssuerDN() {
        return this.issuer_;
    }

    public BigInteger getSerialNumber() {
        return this.serial_.getBigInteger();
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.dAlg_;
    }

    public String getAlgorithm() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.algorithm_ == null) {
            this.init();
        }
        return this.algorithm_;
    }

    public AlgorithmParameterSpec getParameterSpec() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.spec_ == null) {
            this.init();
        }
        return this.spec_;
    }

    protected void init() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmParameters params;
        String c;
        String d = this.dAlg_.getAlgorithmOID().toString();
        String s = JCA.getSignatureName(d, c = this.cAlg_.getAlgorithmOID().toString());
        if (s != null) {
            this.algorithm_ = s;
            return;
        }
        s = JCA.resolveAlias("Signature", d);
        if (s != null) {
            this.algorithm_ = s;
            params = this.dAlg_.getParameters();
        } else {
            s = JCA.resolveAlias("Signature", c);
            if (s != null) {
                this.algorithm_ = s;
                params = this.cAlg_.getParameters();
            } else {
                throw new NoSuchAlgorithmException("Cannot resolve OIDs!");
            }
        }
        try {
            this.spec_ = params == null ? null : params.getParameterSpec(class$java$security$spec$AlgorithmParameterSpec == null ? (class$java$security$spec$AlgorithmParameterSpec = SignerInfo.class$("java.security.spec.AlgorithmParameterSpec")) : class$java$security$spec$AlgorithmParameterSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException("Cannot convert params into spec!");
        }
    }

    public boolean equivIssuerAndSerialNumber(X509Certificate cert) {
        if (cert == null) {
            throw new NullPointerException("Need a cert!");
        }
        if (!this.issuer_.equals(cert.getIssuerDN())) {
            return false;
        }
        return this.serial_.getBigInteger().equals(cert.getSerialNumber());
    }

    public String toString() {
        String alg;
        try {
            alg = this.getAlgorithm();
        }
        catch (Exception e) {
            alg = "<unknown>";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("PKCS#7 SignerInfo {\nVersion   : " + this.version_.toString() + "\n" + "Issuer    : " + this.issuer_.getName() + "\n" + "Serial    : " + this.serial_.toString() + "\n" + "Algorithm : " + alg + "\n" + "Auth A    : " + this.auth_.size() + " elements\n" + "Unauth A  : " + this.attr_.size() + " elements\n" + "Signature : " + this.edig_.toString() + "\n");
        if (this.auth_.size() > 0) {
            buf.append("\n" + this.auth_);
        }
        buf.append("}\n");
        return buf.toString();
    }

    public void encode(Encoder encoder) throws IOException, ASN1Exception {
        ASN1Type t = (ASN1Type)this.get(3);
        boolean opt = this.auth_.size() == 0;
        t.setOptional(opt);
        t = (ASN1Type)this.get(6);
        opt = this.attr_.size() == 0;
        t.setOptional(opt);
        super.encode(encoder);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

