/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1RegisteredType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Set;
import codec.asn1.ASN1SetOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.pkcs7.Certificates;
import codec.pkcs7.Data;
import codec.pkcs7.EncryptedContentInfo;
import codec.pkcs7.RecipientInfo;
import codec.pkcs7.Signable;
import codec.pkcs7.SignerInfo;
import codec.util.CertificateSource;
import codec.x501.BadNameException;
import codec.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;

public class SignedAndEnvelopedData
extends ASN1Sequence
implements ASN1RegisteredType,
CertificateSource,
Signable,
Serializable {
    private static final int[] THIS_OID = new int[]{1, 2, 840, 113549, 1, 7, 4};
    private static final int[] DATA_OID = new int[]{1, 2, 840, 113549, 1, 7, 1};
    protected ASN1Set digestID_;
    protected Certificates certs_;
    protected ASN1SetOf sInfos_;
    protected ASN1Set crls_;
    protected ASN1SetOf recipients_;
    protected EncryptedContentInfo info_;
    protected ASN1Set cache_;
    protected CertificateFactory factory_;
    static /* synthetic */ Class class$codec$pkcs7$RecipientInfo;
    static /* synthetic */ Class class$codec$x509$AlgorithmIdentifier;
    static /* synthetic */ Class class$codec$asn1$ASN1Opaque;
    static /* synthetic */ Class class$codec$pkcs7$SignerInfo;

    public SignedAndEnvelopedData() {
        super(6);
        this.add(new ASN1Integer(1));
        this.recipients_ = new ASN1SetOf(class$codec$pkcs7$RecipientInfo == null ? (class$codec$pkcs7$RecipientInfo = SignedAndEnvelopedData.class$("codec.pkcs7.RecipientInfo")) : class$codec$pkcs7$RecipientInfo);
        this.add(this.recipients_);
        this.digestID_ = new ASN1SetOf(class$codec$x509$AlgorithmIdentifier == null ? (class$codec$x509$AlgorithmIdentifier = SignedAndEnvelopedData.class$("codec.x509.AlgorithmIdentifier")) : class$codec$x509$AlgorithmIdentifier);
        this.add(this.digestID_);
        this.info_ = new EncryptedContentInfo();
        this.add(this.info_);
        this.certs_ = new Certificates();
        this.add(new ASN1TaggedType(0, this.certs_, false, true));
        this.crls_ = new ASN1SetOf(class$codec$asn1$ASN1Opaque == null ? (class$codec$asn1$ASN1Opaque = SignedAndEnvelopedData.class$("codec.asn1.ASN1Opaque")) : class$codec$asn1$ASN1Opaque);
        this.add(new ASN1TaggedType(1, this.crls_, false, true));
        this.sInfos_ = new ASN1SetOf(class$codec$pkcs7$SignerInfo == null ? (class$codec$pkcs7$SignerInfo = SignedAndEnvelopedData.class$("codec.pkcs7.SignerInfo")) : class$codec$pkcs7$SignerInfo);
        this.add(this.sInfos_);
    }

    public SignedAndEnvelopedData(SecretKey bek, String bea, AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        super(6);
        this.add(new ASN1Integer(1));
        this.recipients_ = new ASN1SetOf(class$codec$pkcs7$RecipientInfo == null ? (class$codec$pkcs7$RecipientInfo = SignedAndEnvelopedData.class$("codec.pkcs7.RecipientInfo")) : class$codec$pkcs7$RecipientInfo);
        this.add(this.recipients_);
        this.digestID_ = new ASN1SetOf(class$codec$x509$AlgorithmIdentifier == null ? (class$codec$x509$AlgorithmIdentifier = SignedAndEnvelopedData.class$("codec.x509.AlgorithmIdentifier")) : class$codec$x509$AlgorithmIdentifier);
        this.add(this.digestID_);
        this.info_ = new EncryptedContentInfo(bea, bek, params);
        this.add(this.info_);
        this.certs_ = new Certificates();
        this.add(new ASN1TaggedType(0, this.certs_, false, true));
        this.crls_ = new ASN1SetOf(class$codec$asn1$ASN1Opaque == null ? (class$codec$asn1$ASN1Opaque = SignedAndEnvelopedData.class$("codec.asn1.ASN1Opaque")) : class$codec$asn1$ASN1Opaque);
        this.add(new ASN1TaggedType(1, this.crls_, false, true));
        this.sInfos_ = new ASN1SetOf(class$codec$pkcs7$SignerInfo == null ? (class$codec$pkcs7$SignerInfo = SignedAndEnvelopedData.class$("codec.pkcs7.SignerInfo")) : class$codec$pkcs7$SignerInfo);
        this.add(this.sInfos_);
    }

    public void addCertificate(X509Certificate cert) {
        if (this.certs_.addCertificate(cert)) {
            ((ASN1Type)this.get(4)).setOptional(false);
        }
    }

    public void addRecipient(X509Certificate cert) throws GeneralSecurityException, BadNameException {
        if (!this.hasRecipient(cert)) {
            this.recipients_.add(this.info_.newRecipient(cert));
        }
    }

    public void addSignerInfo(SignerInfo info) {
        if (info == null) {
            throw new NullPointerException("Need a SignerInfo!");
        }
        this.sInfos_.add(info);
        AlgorithmIdentifier idn = info.getDigestAlgorithmIdentifier();
        Iterator i = ((AbstractList)this.digestID_).iterator();
        while (i.hasNext()) {
            AlgorithmIdentifier idv = (AlgorithmIdentifier)i.next();
            if (!idn.equals(idv)) continue;
            return;
        }
        this.digestID_.add(idn);
    }

    public Iterator certificates(Principal subject) {
        return this.certs_.certificates(subject);
    }

    public Iterator certificates(Principal subject, int keyUsage) {
        return this.certs_.certificates(subject, keyUsage);
    }

    public void decryptBulkData(InputStream in, OutputStream out) throws IOException, GeneralSecurityException {
        this.info_.crypt(in, out, 2);
    }

    public byte[] decryptBulkData(byte[] b) throws GeneralSecurityException {
        return this.info_.crypt(b, 0, b.length, 2);
    }

    public void encryptBulkData(InputStream in, OutputStream out) throws IOException, GeneralSecurityException {
        this.info_.crypt(in, out, 1);
    }

    public byte[] encryptBulkData(byte[] b) throws GeneralSecurityException {
        return this.info_.crypt(b, 0, b.length, 1);
    }

    public X509Certificate getCertificate(Principal issuer, BigInteger serial) {
        return this.certs_.getCertificate(issuer, serial);
    }

    public List getCertificates() {
        return Collections.unmodifiableList(this.certs_);
    }

    public ASN1Type getContent() throws GeneralSecurityException {
        return new Data(this.getData());
    }

    public ASN1ObjectIdentifier getContentType() {
        return (ASN1ObjectIdentifier)this.info_.getContentType().clone();
    }

    public byte[] getData() throws GeneralSecurityException, NoSuchElementException {
        return this.info_.getData();
    }

    public ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(THIS_OID);
    }

    public RecipientInfo getRecipientInfo(X509Certificate cert) {
        Iterator i = ((AbstractList)this.recipients_).iterator();
        while (i.hasNext()) {
            RecipientInfo ri = (RecipientInfo)i.next();
            if (!ri.getIssuer().equals(cert.getIssuerDN()) || !ri.getSerialNumber().equals(cert.getSerialNumber())) continue;
            return ri;
        }
        return null;
    }

    public List getRecipientInfos() {
        return Collections.unmodifiableList(this.recipients_);
    }

    public SecretKey getSecretKey() {
        return this.info_.getSecretKey();
    }

    public SignerInfo getSignerInfo(X509Certificate cert) {
        Iterator i = this.getSignerInfos().iterator();
        while (i.hasNext()) {
            SignerInfo info = (SignerInfo)i.next();
            if (!info.getIssuerDN().equals(cert.getIssuerDN()) || !info.getSerialNumber().equals(cert.getSerialNumber())) continue;
            return info;
        }
        return null;
    }

    public List getSignerInfos() {
        return Collections.unmodifiableList(this.sInfos_);
    }

    public boolean hasRecipient(X509Certificate cert) {
        return this.getRecipientInfo(cert) != null;
    }

    public void init(X509Certificate cert, PrivateKey kdk) throws GeneralSecurityException, NoSuchElementException {
        RecipientInfo ri = this.getRecipientInfo(cert);
        if (ri == null) {
            throw new NoSuchElementException("No such recipient exists!");
        }
        this.info_.init(kdk, ri);
    }

    public boolean isReady() {
        return this.info_.isReady();
    }

    public void setCertificateFactory(CertificateFactory factory) {
        this.certs_.setCertificateFactory(factory);
    }

    public void setContentType(ASN1ObjectIdentifier oid) {
        if (oid == null) {
            throw new NullPointerException("OID");
        }
        this.info_.setContentType(oid);
    }

    public void setData(byte[] b) throws IOException, GeneralSecurityException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        try {
            this.info_.setData(bis);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            bis.close();
            throw throwable;
        }
        bis.close();
    }

    public void setData(InputStream in) throws GeneralSecurityException, IOException {
        this.info_.setData(in);
    }

    public void setDataContentType() {
        this.setContentType(new ASN1ObjectIdentifier(DATA_OID));
    }

    public String toString() {
        return "-- PKCS#7 SignedAndEnvelopedData --\n" + super.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

