/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnection;
import homemonitor.wififinder.WifiFinder;
import homemonitor.wififinder.WifiReceiverInterface;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WifiFinderTests {
    private long sessionID = 123L;
    private String ipAddress = "192.168.1.1";
    private String deviceId = "fakeDeviceId";
    private byte[] responseData = new byte[]{102, 97, 107, 101, 82, 101, 115, 112, 111, 110, 115, 101};
    private GatewayDeviceConnection connection;
    private WifiReceiverInterface receiver;
    private WifiFinder wifiFinder;

    @Before
    public void setUp() {
        this.connection = (GatewayDeviceConnection)EasyMock.createMock(GatewayDeviceConnection.class);
        this.receiver = (WifiReceiverInterface)EasyMock.createMock(WifiReceiverInterface.class);
        this.wifiFinder = new WifiFinder(this.connection);
    }

    @Test
    public void testCallSend() {
        EasyMock.expect((Object)this.connection.createSession(this.deviceId, this.wifiFinder)).andReturn((Object)this.sessionID);
        Assert.assertEquals((Object)((Object)GDErrorCode.WrongSessionID), (Object)((Object)this.wifiFinder.send(1L, this.ipAddress)));
        byte[] payload = new byte[]{-64, -88, 1, 1};
        EasyMock.expect((Object)((Object)this.connection.send(EasyMock.eq((int)18), EasyMock.eq((long)this.sessionID), EasyMock.aryEq((byte[])payload)))).andReturn((Object)GDErrorCode.NoError);
        EasyMock.replay((Object[])new Object[]{this.connection});
        this.wifiFinder.createSession(this.deviceId, this.receiver);
        this.wifiFinder.send(this.sessionID, this.ipAddress);
        this.receiver.received("fakeResponse");
        this.receiver.received(null);
        EasyMock.replay((Object[])new Object[]{this.receiver});
        this.wifiFinder.receivedData(this.deviceId, 19, this.sessionID, this.responseData);
        this.wifiFinder.receivedData(this.deviceId, 19, this.sessionID, null);
        EasyMock.verify((Object[])new Object[]{this.connection});
        EasyMock.verify((Object[])new Object[]{this.receiver});
    }
}

