/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.vestiacom.gdserver.service.impl.HttpProxySessions;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import homemonitor.SenderInterface;
import homemonitor.Utility;
import homemonitor.upnp.UPnPApp;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UPnPApp.class})
public class UPnPAppTests {
    private GatewayDeviceConnection gdc;
    private UPnPApp.Callback callback;
    private String mac;
    private HttpClient client;
    private UPnPApp upnp_app;
    private HttpProxySessions httpProxySessions;

    @Before
    public void setUp() {
        this.gdc = (GatewayDeviceConnection)PowerMock.createMock(GatewayDeviceConnection.class);
        this.callback = (UPnPApp.Callback)PowerMock.createMock(UPnPApp.Callback.class);
        this.httpProxySessions = (HttpProxySessions)PowerMock.createMock(HttpProxySessions.class);
        this.mac = "00:00:00:00:00:01";
        this.client = (HttpClient)PowerMock.createMock(HttpClient.class);
        this.upnp_app = new UPnPApp(this.gdc, this.client, true, this.httpProxySessions);
        this.upnp_app.registerCallback(this.callback);
    }

    @After
    public void tearDown() {
        this.gdc = null;
        this.callback = null;
        this.mac = null;
        this.client = null;
        PowerMock.resetAll((Object[])new Object[0]);
    }

    @Test
    public void testSetupForwardingSessionFailed() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.upnp_app))).andReturn((Object)0L);
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        EasyMock.expect((Object)this.gdc.findById((String)EasyMock.eq((Object)this.mac))).andReturn((Object)gd);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.upnp_app.setupForwarding(this.mac, (short)8000));
        PowerMock.verifyAll();
    }

    @Test
    public void testSetupForwardingSendFailed() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.upnp_app))).andReturn((Object)1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)16384);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        EasyMock.expect((Object)this.gdc.findById((String)EasyMock.eq((Object)this.mac))).andReturn((Object)gd);
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)48), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.WrongSessionID);
        this.gdc.destroySession(1L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.upnp_app.setupForwarding(this.mac, (short)16384));
        PowerMock.verifyAll();
    }

    @Test
    public void testSetupForwarding() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.upnp_app))).andReturn((Object)1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)16384);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        EasyMock.expect((Object)this.gdc.findById((String)EasyMock.eq((Object)this.mac))).andReturn((Object)gd);
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)48), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.upnp_app.setupForwarding(this.mac, (short)16384));
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataNoVerification() throws URISyntaxException, ClientProtocolException, IOException {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.upnp_app))).andReturn((Object)1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)8000);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        gd.localIpAddress = "1.0.0.0";
        EasyMock.expect((Object)this.gdc.findById((String)EasyMock.eq((Object)this.mac))).andReturn((Object)gd);
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)48), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        this.callback.forwardingStatus((String)EasyMock.eq((Object)this.mac), (String)EasyMock.eq((Object)"1.0.0.0"), EasyMock.eq((int)0), EasyMock.eq((boolean)true));
        this.gdc.destroySession(1L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.upnp_app.setupForwarding(this.mac, (short)8000));
        buf = ByteBuffer.allocate(6);
        data = buf.array();
        buf.putShort((short)0);
        buf.put(Utility.ipAddressToByteArray("1.0.0.0"));
        this.upnp_app.receivedData(this.mac, 49, 1L, data);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataErrorStatusInResponse() throws URISyntaxException, ClientProtocolException, IOException {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.upnp_app))).andReturn((Object)1L);
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort((short)8000);
        byte[] data = buf.array();
        GatewayDevice gd = new GatewayDevice(this.mac, "1.2.3.4", "1.2.3.1");
        gd.localIpAddress = "1.0.0.0";
        EasyMock.expect((Object)this.gdc.findById((String)EasyMock.eq((Object)this.mac))).andReturn((Object)gd);
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)48), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        this.callback.forwardingStatus(this.mac, null, -1, false);
        this.gdc.destroySession(1L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.upnp_app.setupForwarding(this.mac, (short)8000));
        buf = ByteBuffer.allocate(1);
        data = buf.array();
        buf.put((byte)1);
        this.upnp_app.receivedData(this.mac, 0, 1L, data);
        PowerMock.verifyAll();
    }
}

