/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GatewayDeviceConnection;
import homemonitor.SenderInterface;
import homemonitor.Utility;

public class TCPOverUDPTestApp
implements SenderInterface {
    GatewayDeviceConnection gdc;
    String routerIP;
    int TPTAG_TCPOVERUDP = 16;

    TCPOverUDPTestApp(GatewayDeviceConnection gdc, String ip) {
        this.gdc = gdc;
        this.routerIP = ip;
    }

    public void start() {
        long sessionId = this.gdc.createSession(this.routerIP, this);
        if (sessionId == 0L) {
            System.out.println("Cannot create session for device " + this.routerIP);
            return;
        }
        this.gdc.send(this.TPTAG_TCPOVERUDP, sessionId, null);
    }

    @Override
    public void deviceDisconnected(String deviceId) {
        System.out.println("Device " + this.routerIP + " disconnected. TCP over UDP stopped.");
    }

    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        if (tag == 0) {
            if (data[0] == 0) {
                System.out.println("TCP over UDP proxy started for device " + this.routerIP);
            } else {
                System.out.println("Cannot start TCP over UDP proxy for device " + this.routerIP);
            }
            this.gdc.destroySession(sessionId);
        } else if (tag == 17) {
            int udpPort = Utility.byteArrayToInt(data, 0, 2);
            int portStart = Utility.byteArrayToInt(data, 2, 2);
            int portEnd = Utility.byteArrayToInt(data, 4, 2);
            int ip = Utility.byteArrayToInt(data, 6, 4);
            byte[] ipArray = Utility.intToByteArray(ip);
            String ipStr = new String();
            int i = 0;
            while (i < 4) {
                ipStr = String.valueOf(ipStr) + ipArray[i];
                if (i != 3) {
                    ipStr = String.valueOf(ipStr) + ".";
                }
                ++i;
            }
            System.out.println("TCP over UDP tunnel parameters: remote UDP port: " + udpPort + ", first local TCP port: " + portStart + ", last + 1: " + portEnd + ", local ip: " + ipStr);
        } else {
            System.out.println("TCP over UDP proxy: received message other than status (shouldn't happen)");
        }
    }
}

