/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnection;
import homemonitor.logs.LoggerConfigurator;
import homemonitor.logs.LoggerConfiguratorReceiverInterface;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerConfiguratorTests {
    private long sessionID = 123L;
    private String logConf = "logConf";
    private String deviceId = "fakeDeviceId";
    private GatewayDeviceConnection connection;
    private LoggerConfiguratorReceiverInterface receiver;
    private LoggerConfigurator loggerConfigurator;

    @Before
    public void setUp() {
        this.connection = (GatewayDeviceConnection)EasyMock.createMock(GatewayDeviceConnection.class);
        this.receiver = (LoggerConfiguratorReceiverInterface)EasyMock.createMock(LoggerConfiguratorReceiverInterface.class);
        this.loggerConfigurator = new LoggerConfigurator(this.connection);
    }

    @Test
    public void testCallSend() {
        EasyMock.expect((Object)this.connection.createSession(this.deviceId, this.loggerConfigurator)).andReturn((Object)this.sessionID);
        Assert.assertEquals((Object)((Object)GDErrorCode.WrongSessionID), (Object)((Object)this.loggerConfigurator.send(1L, this.logConf)));
        byte[] payload = new byte[]{108, 111, 103, 67, 111, 110, 102};
        EasyMock.expect((Object)((Object)this.connection.send(EasyMock.eq((int)21), EasyMock.eq((long)this.sessionID), EasyMock.aryEq((byte[])payload)))).andReturn((Object)GDErrorCode.NoError);
        EasyMock.replay((Object[])new Object[]{this.connection});
        this.loggerConfigurator.createSession(this.deviceId, this.receiver);
        this.loggerConfigurator.send(this.sessionID, this.logConf);
        this.receiver.received(LoggerConfigurationStatus.ERROR);
        this.receiver.received(LoggerConfigurationStatus.SUCCESS);
        EasyMock.replay((Object[])new Object[]{this.receiver});
        byte[] errorResponseData = new byte[]{18};
        this.loggerConfigurator.receivedData(this.deviceId, 0, this.sessionID, errorResponseData);
        byte[] successResponseData = new byte[1];
        this.loggerConfigurator.receivedData(this.deviceId, 0, this.sessionID, successResponseData);
        EasyMock.verify((Object[])new Object[]{this.connection});
        EasyMock.verify((Object[])new Object[]{this.receiver});
    }
}

