/*
 * Decompiled with CFR 0.152.
 */
package tests;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import homemonitor.Echo.EchoApplication;
import homemonitor.Echo.SequentialEchoApp;
import homemonitor.GatewayDeviceConnection;
import homemonitor.HTTPClient.HTTPClient;
import homemonitor.HTTPClient.HTTPClientResult;
import homemonitor.SenderInterface;
import homemonitor.ServerBackend;
import homemonitor.TCPProxy.TCPProxy;
import homemonitor.TCPProxy.TCPProxyApp;
import homemonitor.TCPProxy.TCPProxyNotification;
import homemonitor.UDPProxy.LANDeviceDiscoveryNotification;
import homemonitor.UDPProxy.UDPProxy;
import homemonitor.UDPProxy.UDPProxyNetworkTest;
import homemonitor.UDPProxy.VivotekCameraDiscovery;
import homemonitor.execcmd.ExecCmdApp;
import homemonitor.upnp.UPnPApp;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import tests.TCPOverUDPTestApp;

public class LiveNetworkTest {
    GatewayDeviceConnection gdc;
    ServerBackend serverBackend;
    Thread inputThread = new Thread(){

        @Override
        public void run() {
            Scanner scanner = new Scanner(System.in);
            block2: while (true) {
                String id;
                if ((id = scanner.next()).equals("exit")) {
                    System.exit(0);
                }
                List finalAddresses = LiveNetworkTest.this.getAddresses(id);
                int repetitions = scanner.nextInt();
                String appName = scanner.next();
                String message = "test";
                UDPProxy udpProxy = null;
                TCPProxy tcpProxy = null;
                int tcpLocalPort = 0;
                String tcpIp = null;
                int tcpPort = 0;
                int echoRepets = 0;
                HTTPClient httpClient = null;
                String httpClientUrl = "";
                String udpIp = null;
                int udpPort = 0;
                int udpInterval = 0;
                int udpLimit = 0;
                int upnp_port = 0;
                UPnPApp upnp_app = null;
                String execCommand = null;
                ExecCmdApp execCmdApp = null;
                if (appName.equalsIgnoreCase("chat") || appName.equalsIgnoreCase("seqecho")) {
                    message = scanner.next();
                    if (message.startsWith("\"")) {
                        while (!message.endsWith("\"")) {
                            message = String.valueOf(message) + " " + scanner.next();
                        }
                        message = message.substring(1, message.length() - 1);
                    }
                    if (appName.equalsIgnoreCase("seqecho")) {
                        echoRepets = scanner.nextInt();
                    }
                } else if (appName.equalsIgnoreCase("discover_vivotek")) {
                    udpProxy = new UDPProxy(LiveNetworkTest.this.gdc);
                } else if (appName.equalsIgnoreCase("tcpproxy")) {
                    tcpProxy = new TCPProxy(LiveNetworkTest.this.gdc);
                    tcpLocalPort = scanner.nextInt();
                    tcpIp = scanner.next();
                    tcpPort = scanner.nextInt();
                } else if (appName.equalsIgnoreCase("httpclient")) {
                    tcpProxy = new TCPProxy(LiveNetworkTest.this.gdc);
                    httpClientUrl = scanner.next();
                } else if (appName.equalsIgnoreCase("upnp")) {
                    upnp_port = scanner.nextInt();
                    upnp_app = new UPnPApp(LiveNetworkTest.this.gdc, (HttpClient)new DefaultHttpClient(), true, null);
                    upnp_app.registerCallback(new UPnPApp.Callback(){

                        @Override
                        public void forwardingStatus(String id, String localIp, int statusCode, boolean works) {
                            System.out.println("UPnP: works: " + works + " status: " + statusCode);
                        }
                    });
                } else if (appName.equalsIgnoreCase("execcmd")) {
                    execCmdApp = new ExecCmdApp(LiveNetworkTest.this.gdc);
                    execCommand = scanner.next();
                    if (execCommand.startsWith("\"")) {
                        while (!execCommand.endsWith("\"")) {
                            execCommand = String.valueOf(execCommand) + " " + scanner.next();
                        }
                        execCommand = execCommand.substring(1, execCommand.length() - 1);
                    }
                } else if (appName.equalsIgnoreCase("udpproxynettest")) {
                    udpProxy = new UDPProxy(LiveNetworkTest.this.gdc);
                    udpIp = scanner.next();
                    udpPort = scanner.nextInt();
                    udpInterval = scanner.nextInt();
                    udpLimit = scanner.nextInt();
                }
                int i = 0;
                while (true) {
                    if (i >= repetitions) continue block2;
                    for (String deviceIP : finalAddresses) {
                        SenderInterface echo;
                        if (appName.equalsIgnoreCase("chat")) {
                            echo = new EchoApplication(id, deviceIP, message, LiveNetworkTest.this.gdc);
                            ((EchoApplication)echo).sendEchoRequest();
                            continue;
                        }
                        if (appName.equalsIgnoreCase("discover_vivotek")) {
                            final String currentDevice = deviceIP;
                            VivotekCameraDiscovery discover = new VivotekCameraDiscovery(udpProxy, new LANDeviceDiscoveryNotification(){

                                @Override
                                public void foundNewLANDevice(DiscoveredLanDevice dev) {
                                    System.out.println(String.valueOf(currentDevice) + ": Found camera: MAC: " + dev.getMac() + ", IP: " + dev.getIpAddress() + ", Name: " + dev.getName());
                                }

                                @Override
                                public void discoveryFinished() {
                                    System.out.println(String.valueOf(currentDevice) + ": Vivotek camera discovery finished OK");
                                }

                                @Override
                                public void discoveryError() {
                                    System.out.println(String.valueOf(currentDevice) + ": Vivotek camera discovery finished with error");
                                }
                            });
                            discover.discover(deviceIP);
                            continue;
                        }
                        if (appName.equalsIgnoreCase("tcpproxy")) {
                            TCPProxyApp tcpApp = new TCPProxyApp(tcpLocalPort, deviceIP, tcpIp, tcpPort, tcpProxy, new TCPProxyNotification(){

                                @Override
                                public void serverStarted() {
                                    System.out.println("TCP Proxy server started");
                                }

                                @Override
                                public void error() {
                                    System.out.println("Device connection error");
                                }

                                @Override
                                public void deviceDisconnected() {
                                    System.out.println("Device disconnected");
                                }

                                @Override
                                public void connectionAccepted(String dstIp) {
                                    System.out.println("Connection with device " + dstIp + " estabilished");
                                }

                                @Override
                                public void closed() {
                                    System.out.println("Connection with device closed");
                                }

                                @Override
                                public void clientDisconnected(String ip) {
                                    System.out.println("Disconnected client from IP: " + ip);
                                }

                                @Override
                                public void clientConnected(String ip) {
                                    System.out.println("Connected client from IP: " + ip);
                                }
                            });
                            tcpApp.start();
                            continue;
                        }
                        if (appName.equalsIgnoreCase("seqecho")) {
                            echo = new SequentialEchoApp(id, deviceIP, message, LiveNetworkTest.this.gdc, echoRepets);
                            ((SequentialEchoApp)echo).sendEchoRequest();
                            continue;
                        }
                        if (appName.equalsIgnoreCase("httpclient")) {
                            httpClient = new HTTPClient(tcpProxy, new HTTPClientResult(){

                                @Override
                                public void onNoAccessError() {
                                    System.out.println("HTTPClient: NOACCESS");
                                }

                                @Override
                                public void onHttpError(int statusCode, byte[] content) {
                                    System.out.println("HTTPClient: HTTP-ERROR: " + statusCode);
                                }

                                @Override
                                public void onError(byte[] content) {
                                    System.out.println("HTTPClient: ERROR");
                                }

                                @Override
                                public void onGotHeaders(HashMap<String, String> headers) {
                                    System.out.println("HTTPClient: got headers");
                                }

                                @Override
                                public void onRequestComplete(int statusCode, byte[] content) {
                                    System.out.println("HTTPClient: response:");
                                    System.out.println(new String(content));
                                }
                            });
                            try {
                                httpClient.get(deviceIP, new URL(httpClientUrl));
                            }
                            catch (MalformedURLException e) {
                                System.out.println("HTTPClient: bad url:" + httpClientUrl);
                            }
                            continue;
                        }
                        if (appName.equalsIgnoreCase("upnp")) {
                            upnp_app.setupForwarding(id, (short)upnp_port);
                            continue;
                        }
                        if (appName.equalsIgnoreCase("execcmd")) {
                            execCmdApp.executeCommand(id, execCommand, new ExecCmdApp.Callback(){

                                @Override
                                public void execCmdError(String mac) {
                                    System.out.println("ExecCmd Error");
                                }

                                @Override
                                public void execCmdEffect(String mac, String output, int statusCode) {
                                    System.out.println("ExecCmd [" + statusCode + "] :");
                                    System.out.println(output);
                                }
                            });
                            continue;
                        }
                        if (appName.equalsIgnoreCase("ice")) continue;
                        if (appName.equalsIgnoreCase("tcpoverudp")) {
                            TCPOverUDPTestApp tcpOverUdp = new TCPOverUDPTestApp(LiveNetworkTest.this.gdc, id);
                            tcpOverUdp.start();
                            continue;
                        }
                        if (appName.equalsIgnoreCase("udpproxynettest")) {
                            UDPProxyNetworkTest nettest = new UDPProxyNetworkTest(udpProxy, deviceIP, udpIp, udpPort);
                            nettest.start(udpInterval, udpLimit);
                            continue;
                        }
                        if (appName.equalsIgnoreCase("reset")) {
                            LiveNetworkTest.this.gdc.restartDevice(id);
                            continue;
                        }
                        if (!appName.equalsIgnoreCase("forceupgrade")) continue;
                        LiveNetworkTest.this.gdc.forceUpgrade(id);
                    }
                    ++i;
                }
                break;
            }
        }
    };

    private List<String> getAddresses(String ip) {
        String[] ipRanges;
        ArrayList<String> finalAddresses = new ArrayList<String>();
        String[] stringArray = ipRanges = ip.split(";");
        int n = ipRanges.length;
        int n2 = 0;
        while (n2 < n) {
            String ipRange = stringArray[n2];
            String[] boundaries = ipRange.split("-");
            if (boundaries.length == 1) {
                finalAddresses.add(boundaries[0]);
            } else {
                int[][] intArrays = new int[2][4];
                int addressIndex = 0;
                while (addressIndex < 2) {
                    String[] stringIPArray = boundaries[addressIndex].split("\\.");
                    int j = 0;
                    while (j < 4) {
                        intArrays[addressIndex][j] = Integer.parseInt(stringIPArray[j]);
                        ++j;
                    }
                    ++addressIndex;
                }
                int a = intArrays[0][0];
                while (a <= intArrays[1][0]) {
                    int begB = a == intArrays[0][0] ? intArrays[0][1] : 0;
                    int endB = a == intArrays[1][0] ? intArrays[1][1] : 255;
                    int b = begB;
                    while (b <= endB) {
                        int begC = b == intArrays[0][1] ? intArrays[0][2] : 0;
                        int endC = b == intArrays[1][1] ? intArrays[1][2] : 255;
                        int c = begC;
                        while (c <= endC) {
                            int begD = c == intArrays[0][2] ? intArrays[0][3] : 0;
                            int endD = c == intArrays[1][2] ? intArrays[1][3] : 254;
                            int d = begD;
                            while (d <= endD) {
                                finalAddresses.add(a + "." + b + "." + c + "." + d);
                                ++d;
                            }
                            ++c;
                        }
                        ++b;
                    }
                    ++a;
                }
            }
            ++n2;
        }
        return finalAddresses;
    }

    public LiveNetworkTest(String ip, int port) throws URISyntaxException {
        this.gdc = new GatewayDeviceConnection("/Users/mateuszslupny/remotenas_keys/key.x509", "/Users/mateuszslupny/remotenas_keys/key.cert", "/Users/mateuszslupny/remotenas_keys/ca.cert", "192.168.21.164:8080");
        this.serverBackend = new ServerBackend(ip, port, this.gdc, 1024, 60);
        this.gdc.setServerBackend(this.serverBackend);
    }

    public void start() {
        this.inputThread.start();
    }

    public static void main(String[] args) throws NumberFormatException, URISyntaxException {
        if (args.length < 2) {
            System.out.println("Usage: LiveNetworkTest [address] [port]");
            return;
        }
        LiveNetworkTest test = new LiveNetworkTest(args[0], Integer.parseInt(args[1]));
        System.out.println("Enter IP address of device, number of repetitions, application and its parameters, then press return.");
        System.out.println("If message contains spaces ( ), surround it with quotation marks.");
        System.out.println("You can use semicolon (;) to specify multiple IP addresses,. ");
        System.out.println("or dash (-) to specify a range of addresses.");
        System.out.println("Type 'exit' to close the application.\n");
        System.out.println("Examples:");
        System.out.println("> 192.168.1.123;192.168.1.126-192.168.1.140 3 chat \"hello little device\"");
        System.out.println("> 192.168.1.123;192.168.1.126-192.168.1.140 3 discover_vivotek");
        System.out.println("> 192.168.1.117 1 tcpproxy 234 192.168.21.156 80\n");
        test.start();
    }
}

