/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnection;
import homemonitor.ICETransport.ICETransport;
import homemonitor.ICETransport.ICETransportReceiverInterface;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ICETransportTest {
    private long sessionID = 123L;
    private String stunAddr = "192.168.1.1";
    private int stunPort = 9001;
    private String turnAddr = "192.168.1.2";
    private int turnPort = 9002;
    private String turnUser = "fakeUser";
    private String turnPass = "fakePass";
    private String candidates = "fake";
    private String deviceId = "fakeDeviceId";
    private byte[] responseData = new byte[]{31, 64, 39, 16, 102, 97, 107, 101, 82, 101, 115, 112, 111, 110, 115, 101};
    private GatewayDeviceConnection connectionMock;
    private ICETransportReceiverInterface receiverMock;
    private ICETransport iceTransport;

    @Before
    public void setUp() {
        this.connectionMock = (GatewayDeviceConnection)EasyMock.createMock(GatewayDeviceConnection.class);
        this.receiverMock = (ICETransportReceiverInterface)EasyMock.createMock(ICETransportReceiverInterface.class);
        this.iceTransport = new ICETransport(this.connectionMock);
    }

    @Test
    public void testCallSend() {
        EasyMock.expect((Object)this.connectionMock.createSession(this.deviceId, this.iceTransport)).andReturn((Object)this.sessionID);
        Assert.assertEquals((Object)((Object)GDErrorCode.WrongSessionID), (Object)((Object)this.iceTransport.send(1L, this.stunAddr, this.stunPort, this.turnAddr, this.turnPort, this.turnUser, this.turnPass, this.candidates)));
        byte[] byArray = new byte[48];
        byArray[0] = -64;
        byArray[1] = -88;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 35;
        byArray[5] = 41;
        byArray[6] = -64;
        byArray[7] = -88;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 35;
        byArray[11] = 42;
        byArray[12] = 102;
        byArray[13] = 97;
        byArray[14] = 107;
        byArray[15] = 101;
        byArray[16] = 85;
        byArray[17] = 115;
        byArray[18] = 101;
        byArray[19] = 114;
        byArray[28] = 102;
        byArray[29] = 97;
        byArray[30] = 107;
        byArray[31] = 101;
        byArray[32] = 80;
        byArray[33] = 97;
        byArray[34] = 115;
        byArray[35] = 115;
        byArray[44] = 102;
        byArray[45] = 97;
        byArray[46] = 107;
        byArray[47] = 101;
        byte[] payload = byArray;
        EasyMock.expect((Object)((Object)this.connectionMock.send(EasyMock.eq((int)32), EasyMock.eq((long)this.sessionID), EasyMock.aryEq((byte[])payload)))).andReturn((Object)GDErrorCode.NoError);
        EasyMock.replay((Object[])new Object[]{this.connectionMock});
        this.iceTransport.createSession(this.deviceId, this.receiverMock);
        this.iceTransport.send(this.sessionID, this.stunAddr, this.stunPort, this.turnAddr, this.turnPort, this.turnUser, this.turnPass, this.candidates);
        this.receiverMock.received(8000, 10000, "fakeResponse");
        this.receiverMock.received(0, 0, null);
        EasyMock.replay((Object[])new Object[]{this.receiverMock});
        this.iceTransport.receivedData(this.deviceId, 33, this.sessionID, this.responseData);
        this.iceTransport.receivedData(this.deviceId, 37, this.sessionID, null);
        EasyMock.verify((Object[])new Object[]{this.connectionMock});
        EasyMock.verify((Object[])new Object[]{this.receiverMock});
    }

    @Test
    public void testCallSendWithTooLongUsernameAndPass() {
        EasyMock.expect((Object)this.connectionMock.createSession(this.deviceId, this.iceTransport)).andReturn((Object)this.sessionID);
        Assert.assertEquals((Object)((Object)GDErrorCode.WrongSessionID), (Object)((Object)this.iceTransport.send(1L, this.stunAddr, this.stunPort, this.turnAddr, this.turnPort, this.turnUser, this.turnPass, this.candidates)));
        byte[] payload = new byte[]{-64, -88, 1, 1, 35, 41, -64, -88, 1, 2, 35, 42, 116, 111, 111, 76, 111, 110, 103, 70, 97, 107, 101, 85, 115, 101, 114, 110, 116, 111, 111, 76, 111, 110, 103, 70, 97, 107, 101, 80, 97, 115, 115, 119, 102, 97, 107, 101};
        EasyMock.expect((Object)((Object)this.connectionMock.send(EasyMock.eq((int)32), EasyMock.eq((long)this.sessionID), EasyMock.aryEq((byte[])payload)))).andReturn((Object)GDErrorCode.NoError);
        EasyMock.replay((Object[])new Object[]{this.connectionMock});
        this.iceTransport.createSession(this.deviceId, this.receiverMock);
        this.iceTransport.send(this.sessionID, this.stunAddr, this.stunPort, this.turnAddr, this.turnPort, "tooLongFakeUsername", "tooLongFakePassword", this.candidates);
        EasyMock.verify((Object[])new Object[]{this.connectionMock});
    }
}

