/*
 * Decompiled with CFR 0.152.
 */
package tests;

import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnection;
import homemonitor.SenderInterface;
import homemonitor.execcmd.ExecCmdApp;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ExecCmdApp.class})
public class ExecCmdAppTests {
    private GatewayDeviceConnection gdc = null;
    private ExecCmdApp.Callback callback = null;
    private String mac = "00:00:00:00:00:01";
    private String command = "ps ax | grep GDClient";
    private ExecCmdApp execCmd = null;

    @Before
    public void before() {
        this.gdc = (GatewayDeviceConnection)PowerMock.createMock(GatewayDeviceConnection.class);
        this.callback = (ExecCmdApp.Callback)PowerMock.createMock(ExecCmdApp.Callback.class);
        this.execCmd = new ExecCmdApp(this.gdc);
    }

    @After
    public void after() {
        this.gdc = null;
        this.callback = null;
        PowerMock.resetAll((Object[])new Object[0]);
    }

    @Test
    public void testExecuteCommandFailed() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)0L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCommandSendException() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)80), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.Error);
        this.gdc.destroySession(1L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        PowerMock.verifyAll();
    }

    @Test
    public void testExecuteCommand() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)80), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataNoSession() {
        PowerMock.replayAll((Object[])new Object[0]);
        byte[] rdata = new byte[]{};
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataStatusError() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)80), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        byte[] rdata = new byte[]{1};
        this.callback.execCmdError((String)EasyMock.eq((Object)this.mac));
        this.gdc.destroySession(1L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 0, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataExecStatusTag() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)80), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        byte[] rdata = ByteBuffer.allocate(4).putInt(1).array();
        this.callback.execCmdEffect((String)EasyMock.eq((Object)this.mac), (String)EasyMock.eq((Object)""), EasyMock.eq((int)1));
        this.gdc.destroySession(1L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 82, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataOutputTag() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)80), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        byte[] rdata = "some output".getBytes();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedDataDoubleOutputTag() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)80), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        byte[] rdata = "some output".getBytes();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        PowerMock.verifyAll();
    }

    @Test
    public void testReceivedData2OutputTag1StatusTag() {
        EasyMock.expect((Object)this.gdc.createSession((String)EasyMock.eq((Object)this.mac), (SenderInterface)EasyMock.eq((Object)this.execCmd))).andReturn((Object)1L);
        byte[] data = this.command.getBytes();
        EasyMock.expect((Object)((Object)this.gdc.send(EasyMock.eq((int)80), EasyMock.eq((long)1L), EasyMock.aryEq((byte[])data)))).andReturn((Object)GDErrorCode.NoError);
        byte[] rdata = "some output".getBytes();
        this.callback.execCmdEffect((String)EasyMock.eq((Object)this.mac), (String)EasyMock.eq((Object)"some outputsome output"), EasyMock.eq((int)0));
        this.gdc.destroySession(1L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.execCmd.executeCommand(this.mac, this.command, this.callback));
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        this.execCmd.receivedData(this.mac, 81, 1L, rdata);
        rdata = ByteBuffer.allocate(4).putInt(0).array();
        this.execCmd.receivedData(this.mac, 82, 1L, rdata);
        PowerMock.verifyAll();
    }
}

