/*
 * Decompiled with CFR 0.152.
 */
package tests;

import codec.asn1.DERDecoder;
import codec.asn1.Decoder;
import codec.pkcs12.PFX;
import codec.pkcs12.PKCS8ShroudedKeyBag;
import codec.pkcs12.SafeBag;
import codec.x509.X509Certificate;
import de.flexiprovider.core.FlexiCoreProvider;
import de.flexiprovider.ec.FlexiECProvider;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.parameters.CurveRegistry;
import homemonitor.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;

public class ECDSAEncryption {
    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new FlexiCoreProvider());
        Security.addProvider((Provider)new FlexiECProvider());
        DERDecoder dec = new DERDecoder((InputStream)new FileInputStream("/Users/capsel/test.p12"));
        PFX pfx = new PFX();
        pfx.decode((Decoder)dec);
        SafeBag safeBag = pfx.getAuthSafe().getSafeContents(0).getSafeBag(0);
        PKCS8ShroudedKeyBag kBag = (PKCS8ShroudedKeyBag)safeBag.getBagValue();
        char[] password = "zaq12wsx".toCharArray();
        PrivateKey privKey = kBag.getPrivateKey(password);
        Signature sig = Signature.getInstance("SHA1withECDSA", "FlexiEC");
        sig.setParameter((AlgorithmParameterSpec)new CurveRegistry.Secp128r2());
        sig.initSign(privKey);
        String tocrypt = "0123456789abcdef";
        System.err.println("tocrypt = `" + tocrypt + "', getBytes().length = " + tocrypt.getBytes().length);
        sig.update(tocrypt.getBytes());
        byte[] encrypted = sig.sign();
        String str = new String(encrypted);
        System.out.println("`" + tocrypt + "' -> `" + str + "'");
        File file = new File("/Users/capsel/cert.cer");
        byte[] certbytes = new byte[(int)file.length()];
        FileInputStream fis = new FileInputStream(file);
        fis.read(certbytes);
        fis.close();
        X509Certificate cert = new X509Certificate(certbytes);
        PublicKey pubKey = cert.getPublicKey();
        ECPublicKey key = (ECPublicKey)pubKey;
        System.out.println("x = " + key.getW().getX() + ", y = " + key.getW().getY());
        BigInteger heh = BigInteger.valueOf(128L);
        System.out.println("heh=" + Utility.byteArrayToHexString(heh.toByteArray(), 0, heh.toByteArray().length, " "));
        System.out.println("public key: " + new String(pubKey.getEncoded()));
        sig = Signature.getInstance("SHA1withECDSA", "FlexiEC");
        sig.initVerify(pubKey);
        sig.update(tocrypt.getBytes());
        System.out.println("verified = " + sig.verify(encrypted));
    }
}

