/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import se.unlogic.standardutils.threads.SimpleExecutionController;
import se.unlogic.standardutils.threads.Status;
import se.unlogic.standardutils.threads.TaskGroup;
import se.unlogic.standardutils.threads.TaskGroupHandler;

public class ThreadPoolTaskGroupHandler<T extends TaskGroup>
implements TaskGroupHandler<T, SimpleExecutionController<T>>,
Runnable {
    protected final ReentrantLock taskGroupRemoveLock = new ReentrantLock();
    protected final Condition taskGroupRemoveCondition = this.taskGroupRemoveLock.newCondition();
    protected final ReentrantLock taskGroupAddLock = new ReentrantLock();
    protected final Condition taskGroupAddCondition = this.taskGroupAddLock.newCondition();
    protected final CopyOnWriteArrayList<SimpleExecutionController<T>> taskGroupList = new CopyOnWriteArrayList();
    protected int taskGroupIndex = 0;
    protected Status status = Status.RUNNING;
    protected final ArrayList<Thread> threads = new ArrayList();

    public ThreadPoolTaskGroupHandler(int poolSize, boolean daemon) {
        while (this.threads.size() < poolSize) {
            Thread thread = new Thread((Runnable)this, "TaskGroupHandler thread " + (this.threads.size() + 1));
            thread.setDaemon(daemon);
            this.threads.add(thread);
            thread.start();
        }
    }

    @Override
    public void run() {
        Runnable task = null;
        while (true) {
            block22: {
                block21: {
                    block19: {
                        if (!this.taskGroupList.isEmpty() && this.status != Status.SHUTDOWN) {
                            SimpleExecutionController<T> executionController;
                            try {
                                executionController = this.taskGroupList.get(this.getIndex());
                            }
                            catch (IndexOutOfBoundsException e) {
                                continue;
                            }
                            task = (Runnable)executionController.getTaskQueue().poll();
                            if (task == null) {
                                this.taskGroupRemoveLock.lock();
                                try {
                                    if (executionController.getInitialTaskCount() == executionController.getCompletedTaskCount() && this.taskGroupList.contains(executionController)) {
                                        this.taskGroupList.remove(executionController);
                                        this.taskGroupRemoveCondition.signalAll();
                                        executionController.executionComplete();
                                    }
                                    break block19;
                                }
                                finally {
                                    this.taskGroupRemoveLock.unlock();
                                }
                            }
                            try {
                                try {
                                    task.run();
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    executionController.incrementCompletedTaskCount();
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                executionController.incrementCompletedTaskCount();
                                throw throwable;
                            }
                            executionController.incrementCompletedTaskCount();
                            continue;
                        }
                    }
                    this.taskGroupAddLock.lock();
                    if (this.status != Status.TERMINATING) break block21;
                    if (this.getLiveThreads() == 1) {
                        this.status = Status.SHUTDOWN;
                    }
                    this.taskGroupAddLock.unlock();
                    return;
                }
                try {
                    try {
                        if (!this.isEmpty()) break block22;
                        this.taskGroupAddCondition.await();
                    }
                    catch (InterruptedException interruptedException) {
                        this.taskGroupAddLock.unlock();
                    }
                }
                catch (Throwable throwable) {
                    this.taskGroupAddLock.unlock();
                    throw throwable;
                }
            }
            this.taskGroupAddLock.unlock();
        }
    }

    public boolean isEmpty() {
        if (this.taskGroupList.isEmpty()) {
            return true;
        }
        for (SimpleExecutionController<T> controller : this.taskGroupList) {
            if (controller.getTaskQueue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getLiveThreads() {
        int activeThreadCount = 0;
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            ++activeThreadCount;
        }
        return activeThreadCount;
    }

    protected synchronized int getIndex() {
        ++this.taskGroupIndex;
        if (this.taskGroupIndex >= this.taskGroupList.size()) {
            this.taskGroupIndex = 0;
        }
        return this.taskGroupIndex;
    }

    void remove(SimpleExecutionController<T> executionController) {
        this.taskGroupRemoveLock.lock();
        try {
            this.taskGroupList.remove(executionController);
            this.taskGroupRemoveCondition.signalAll();
        }
        finally {
            this.taskGroupRemoveLock.unlock();
        }
    }

    void add(SimpleExecutionController<T> executionController) {
        block4: {
            this.taskGroupAddLock.lock();
            try {
                if (this.status == Status.RUNNING) {
                    this.taskGroupList.add(executionController);
                    this.taskGroupAddCondition.signalAll();
                    break block4;
                }
                throw new RejectedExecutionException("TaskGroupHandler status " + (Object)((Object)this.status));
            }
            finally {
                this.taskGroupAddLock.unlock();
            }
        }
    }

    @Override
    public void abortAllTaskGroups() {
        this.taskGroupRemoveLock.lock();
        try {
            while (!this.taskGroupList.isEmpty()) {
                for (SimpleExecutionController<T> executionController : this.taskGroupList) {
                    executionController.abort();
                }
            }
        }
        finally {
            this.taskGroupRemoveLock.unlock();
        }
    }

    @Override
    public SimpleExecutionController<T> execute(T taskGroup) throws RejectedExecutionException {
        if (this.status == Status.RUNNING) {
            return new SimpleExecutionController<T>(taskGroup, this);
        }
        throw new RejectedExecutionException("TaskGroupHandler status " + (Object)((Object)this.status));
    }

    @Override
    public int getTaskGroupCount() {
        return this.taskGroupList.size();
    }

    @Override
    public List<SimpleExecutionController<T>> getTaskGroups() {
        return new ArrayList<SimpleExecutionController<T>>(this.taskGroupList);
    }

    @Override
    public int getTotalTaskCount() {
        int taskCount = 0;
        for (SimpleExecutionController<T> executionController : this.taskGroupList) {
            taskCount += executionController.getTaskQueue().size();
        }
        return taskCount;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        this.taskGroupRemoveLock.lock();
        try {
            while (!this.taskGroupList.isEmpty()) {
                this.taskGroupRemoveCondition.await();
            }
        }
        finally {
            this.taskGroupRemoveLock.unlock();
        }
    }

    @Override
    public void awaitTermination(long timeout) throws InterruptedException {
        this.taskGroupRemoveLock.lock();
        try {
            while (!this.taskGroupList.isEmpty()) {
                this.taskGroupRemoveCondition.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.taskGroupRemoveLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.taskGroupAddLock.lock();
        try {
            if (this.status == Status.RUNNING) {
                this.status = Status.TERMINATING;
                this.taskGroupAddCondition.signalAll();
            }
        }
        finally {
            this.taskGroupAddLock.unlock();
        }
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
        this.abortAllTaskGroups();
    }
}

