/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.settings;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.settings.SettingNode;
import se.unlogic.standardutils.xml.XMLUtils;

public class XMLSettingNode
implements SettingNode {
    private final Element element;
    private final XPath xpath;

    public XMLSettingNode(String path) throws SAXException, IOException, ParserConfigurationException {
        Document doc = XMLUtils.parseXmlFile(path, false, false);
        this.element = doc.getDocumentElement();
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public XMLSettingNode(Document doc) {
        this.element = doc.getDocumentElement();
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public XMLSettingNode(Element element) {
        this.element = element;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public XMLSettingNode(File configurationFile) throws SAXException, IOException, ParserConfigurationException {
        Document doc = XMLUtils.parseXmlFile(configurationFile, false);
        this.element = doc.getDocumentElement();
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    @Override
    public Boolean getBoolean(String expression) {
        return Boolean.valueOf(this.getString(expression));
    }

    @Override
    public boolean getPrimitiveBoolean(String expression) {
        return Boolean.parseBoolean(this.getString(expression));
    }

    @Override
    public Double getDouble(String expression) {
        String value = this.getString(expression);
        if (value != null) {
            return NumberUtils.toDouble(value);
        }
        return null;
    }

    @Override
    public List<Double> getDoubles(String expression) {
        NodeList nodes = this.getNodeList(expression);
        ArrayList<Double> doubles = new ArrayList<Double>();
        int i = 0;
        while (i < nodes.getLength()) {
            Double numberValue;
            String value = nodes.item(i).getTextContent();
            if (value != null && (numberValue = NumberUtils.toDouble(value)) != null) {
                doubles.add(numberValue);
            }
            ++i;
        }
        return doubles;
    }

    @Override
    public int getInt(String expression) {
        String value = this.getString(expression);
        if (value != null && NumberUtils.isInt(value)) {
            return NumberUtils.toInt(value);
        }
        return 0;
    }

    @Override
    public Integer getInteger(String expression) {
        String value = this.getString(expression);
        if (value != null) {
            return NumberUtils.toInt(value);
        }
        return null;
    }

    @Override
    public List<Integer> getIntegers(String expression) {
        NodeList nodes = this.getNodeList(expression);
        ArrayList<Integer> integers = new ArrayList<Integer>();
        int i = 0;
        while (i < nodes.getLength()) {
            Integer numberValue;
            String value = nodes.item(i).getTextContent();
            if (value != null && (numberValue = NumberUtils.toInt(value)) != null) {
                integers.add(numberValue);
            }
            ++i;
        }
        return integers;
    }

    @Override
    public Long getLong(String expression) {
        String value = this.getString(expression);
        if (value != null) {
            return NumberUtils.toLong(value);
        }
        return null;
    }

    @Override
    public List<Long> getLongs(String expression) {
        NodeList nodes = this.getNodeList(expression);
        ArrayList<Long> longs = new ArrayList<Long>();
        int i = 0;
        while (i < nodes.getLength()) {
            Long numberValue;
            String value = nodes.item(i).getTextContent();
            if (value != null && (numberValue = NumberUtils.toLong(value)) != null) {
                longs.add(numberValue);
            }
            ++i;
        }
        return longs;
    }

    @Override
    public XMLSettingNode getSetting(String expression) {
        Element element = this.getElement(expression);
        if (element == null) {
            return null;
        }
        return new XMLSettingNode(element);
    }

    public List<XMLSettingNode> getSettings(String expression) {
        NodeList nodes = this.getNodeList(expression);
        ArrayList<XMLSettingNode> settingNodes = new ArrayList<XMLSettingNode>();
        int i = 0;
        while (i < nodes.getLength()) {
            settingNodes.add(new XMLSettingNode((Element)nodes.item(i)));
            ++i;
        }
        return settingNodes;
    }

    @Override
    public String getString(String expression) {
        try {
            return this.xpath.evaluate(expression, this.element);
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    @Override
    public List<String> getStrings(String expression) {
        NodeList nodes = this.getNodeList(expression);
        if (nodes != null && nodes.getLength() > 0) {
            ArrayList<String> strings = new ArrayList<String>();
            int i = 0;
            while (i < nodes.getLength()) {
                strings.add(nodes.item(i).getTextContent());
                ++i;
            }
            return strings;
        }
        return null;
    }

    private NodeList getNodeList(String expression) {
        try {
            return (NodeList)this.xpath.evaluate(expression, this.element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    private Element getElement(String expression) {
        try {
            return (Element)this.xpath.evaluate(expression, this.element, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public String getElementName() {
        return this.element.getTagName();
    }
}

