/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.unlogic.standardutils.dao.script.Offsets;
import se.unlogic.standardutils.dao.script.Region;
import se.unlogic.standardutils.dao.script.ScriptUtility;
import se.unlogic.standardutils.dao.script.Symbol;

public class MySQLScriptUtility
implements ScriptUtility {
    private static final String MULTI_LINE_COMMENT_START_SYMBOL = "\\/\\*";
    private static final String MULTI_LINE_COMMENT_END_SYMBOL = "\\*\\/";
    private static final String LINE_COMMENT_START_SYMBOL = "^--|^#";
    private static final String LINE_COMMENT_END_SYMBOL = "\\n";
    private static final String STRING_TYPE1_SYMBOL = "'";
    private static final String STRING_TYPE2_SYMBOL = "\"";
    private static final String STATEMENT_TERMINATOR = ";";

    @Override
    public List<String> getStatements(String script) {
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<Symbol> allSymbols = new ArrayList<Symbol>();
        allSymbols.addAll(this.findSymbols(STRING_TYPE1_SYMBOL, script));
        allSymbols.addAll(this.findSymbols(STRING_TYPE2_SYMBOL, script));
        allSymbols.addAll(this.findSymbols(LINE_COMMENT_START_SYMBOL, script));
        allSymbols.addAll(this.findSymbols(LINE_COMMENT_END_SYMBOL, script));
        allSymbols.addAll(this.findSymbols(MULTI_LINE_COMMENT_START_SYMBOL, script));
        allSymbols.addAll(this.findSymbols(MULTI_LINE_COMMENT_END_SYMBOL, script));
        String str = script;
        int startIndex = 0;
        for (Symbol terminator : this.getValidSymbols(this.findSymbols(STATEMENT_TERMINATOR, script), this.createRegions(this.getValidSymbols(allSymbols)))) {
            str = script.substring(startIndex, terminator.getOffsets().getEnd());
            startIndex += str.length();
            statements.add(str);
        }
        return statements;
    }

    private List<Symbol> findSymbols(String regex, String sequence) {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(sequence);
        while (matcher.find()) {
            symbols.add(new Symbol(regex, new Offsets(matcher.start(), matcher.end())));
        }
        return symbols;
    }

    private List<Region> createRegions(List<Symbol> symbols) {
        ArrayList<Region> regions = new ArrayList<Region>();
        Symbol stringType1Symbol = null;
        Symbol stringType2Symbol = null;
        Symbol lineCommentStartSymbol = null;
        Symbol multiLineCommentStartSymbol = null;
        for (Symbol symbol : symbols) {
            if (symbol.getKey().equals(STRING_TYPE1_SYMBOL)) {
                if (stringType1Symbol != null) {
                    regions.add(new Region(stringType1Symbol, symbol));
                    stringType1Symbol = null;
                    continue;
                }
                stringType1Symbol = symbol;
                continue;
            }
            if (symbol.getKey().equals(STRING_TYPE2_SYMBOL)) {
                if (stringType2Symbol != null) {
                    regions.add(new Region(stringType2Symbol, symbol));
                    stringType2Symbol = null;
                    continue;
                }
                stringType2Symbol = symbol;
                continue;
            }
            if (symbol.getKey().equals(LINE_COMMENT_END_SYMBOL) && lineCommentStartSymbol != null) {
                regions.add(new Region(lineCommentStartSymbol, symbol));
                lineCommentStartSymbol = null;
                continue;
            }
            if (symbol.getKey().equals(LINE_COMMENT_START_SYMBOL)) {
                lineCommentStartSymbol = symbol;
                continue;
            }
            if (symbol.getKey().equals(MULTI_LINE_COMMENT_END_SYMBOL) && multiLineCommentStartSymbol != null) {
                regions.add(new Region(multiLineCommentStartSymbol, symbol));
                multiLineCommentStartSymbol = null;
                continue;
            }
            if (!symbol.getKey().equals(MULTI_LINE_COMMENT_START_SYMBOL)) continue;
            multiLineCommentStartSymbol = symbol;
        }
        if (stringType1Symbol != null) {
            regions.add(new Region(stringType1Symbol, null));
            stringType1Symbol = null;
        }
        if (stringType2Symbol != null) {
            regions.add(new Region(stringType2Symbol, null));
            stringType2Symbol = null;
        }
        if (lineCommentStartSymbol != null) {
            regions.add(new Region(lineCommentStartSymbol, null));
            lineCommentStartSymbol = null;
        }
        if (multiLineCommentStartSymbol != null) {
            regions.add(new Region(multiLineCommentStartSymbol, null));
            multiLineCommentStartSymbol = null;
        }
        return regions;
    }

    private List<Symbol> getValidSymbols(List<Symbol> symbols) {
        ArrayList<Symbol> validSymbols = new ArrayList<Symbol>();
        boolean withinStringType1 = false;
        boolean withinStringType2 = false;
        boolean withinLineComment = false;
        boolean withinMultiLineComment = false;
        Collections.sort(symbols, new Symbol.SymbolStartComparator());
        for (Symbol symbol : symbols) {
            if (!(withinStringType1 || withinStringType2 || withinLineComment || withinMultiLineComment)) {
                validSymbols.add(symbol);
                if (symbol.getKey().equals(STRING_TYPE1_SYMBOL)) {
                    withinStringType1 = true;
                    continue;
                }
                if (symbol.getKey().equals(STRING_TYPE2_SYMBOL)) {
                    withinStringType2 = true;
                    continue;
                }
                if (symbol.getKey().equals(LINE_COMMENT_START_SYMBOL)) {
                    withinLineComment = true;
                    continue;
                }
                if (!symbol.getKey().equals(MULTI_LINE_COMMENT_START_SYMBOL)) continue;
                withinMultiLineComment = true;
                continue;
            }
            if (withinStringType1 && symbol.getKey().equals(STRING_TYPE1_SYMBOL)) {
                validSymbols.add(symbol);
                withinStringType1 = false;
                continue;
            }
            if (withinStringType2 && symbol.getKey().equals(STRING_TYPE2_SYMBOL)) {
                validSymbols.add(symbol);
                withinStringType2 = false;
                continue;
            }
            if (withinLineComment && symbol.getKey().equals(LINE_COMMENT_END_SYMBOL)) {
                validSymbols.add(symbol);
                withinLineComment = false;
                continue;
            }
            if (!withinMultiLineComment || !symbol.getKey().equals(MULTI_LINE_COMMENT_END_SYMBOL)) continue;
            validSymbols.add(symbol);
            withinMultiLineComment = false;
        }
        return validSymbols;
    }

    private List<Symbol> getValidSymbols(List<Symbol> symbols, List<Region> invalidRegions) {
        ArrayList<Symbol> validSymbols = new ArrayList<Symbol>();
        block0: for (Symbol symbol : symbols) {
            for (Region invalidRegion : invalidRegions) {
                if (symbol.getOffsets().getStart() >= invalidRegion.getStart() && (invalidRegion.getEnd() == null || symbol.getOffsets().getStart() < invalidRegion.getEnd())) continue block0;
            }
            validSymbols.add(symbol);
        }
        return validSymbols;
    }
}

