/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import se.unlogic.eagledns.EagleDNS;
import se.unlogic.eagledns.TCPConnection;

public class TCPSocketMonitor
extends Thread {
    private Logger log = Logger.getLogger(this.getClass());
    private final EagleDNS eagleDNS;
    private final InetAddress addr;
    private final int port;
    private final ServerSocket serverSocket;

    public TCPSocketMonitor(EagleDNS eagleDNS, InetAddress addr, int port) throws IOException {
        this.eagleDNS = eagleDNS;
        this.addr = addr;
        this.port = port;
        this.serverSocket = new ServerSocket(port, 128, addr);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        this.log.debug((Object)("Starting TCP socket monitor on address " + this.getAddressAndPort()));
        while (!this.eagleDNS.isShutdown()) {
            try {
                Socket socket = this.serverSocket.accept();
                this.log.debug((Object)("TCP connection from " + socket.getRemoteSocketAddress()));
                this.eagleDNS.getTcpThreadPool().execute(new TCPConnection(this.eagleDNS, socket));
            }
            catch (SocketException e) {
                this.log.debug((Object)("SocketException thrown from TCP socket on address " + this.getAddressAndPort() + ", " + e));
            }
            catch (IOException e) {
                this.log.info((Object)("IOException thrown by TCP socket on address " + this.getAddressAndPort() + ", " + e));
            }
        }
        this.log.debug((Object)("TCP socket monitor on address " + this.getAddressAndPort() + " shutdown"));
    }

    public InetAddress getAddr() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void closeSocket() throws IOException {
        this.log.debug((Object)("Closing TCP socket monitor on address " + this.getAddressAndPort() + "..."));
        this.serverSocket.close();
    }

    public String getAddressAndPort() {
        return String.valueOf(this.addr.getHostAddress()) + ":" + this.port;
    }
}

