/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.upnp;

import com.vestiacom.gdserver.service.impl.HttpProxySessions;
import homemonitor.Utility;
import homemonitor.upnp.UPnPAppCallback;
import homemonitor.upnp.UPnPAppTransmitter;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;

class UPnPAppHandler {
    private UPnPAppCallback callback = null;
    private UPnPAppTransmitter transmitter = null;
    private static Logger log = Logger.getLogger(UPnPAppHandler.class);
    private int status_code = -1;
    private boolean forward_status = false;
    private short tested_port = 0;
    private String local_ip = null;
    private String public_ip = null;
    private String id = null;
    HttpClient client = null;
    private boolean skipVerification = false;
    private HttpProxySessions httpProxySessions;

    public boolean receivedData(int tag, byte[] data) {
        if (tag != 49 || data.length != 6) {
            log.error((Object)"GDClient responded with wrong tag or message size!");
            this.status_code = -1;
            this.forward_status = false;
        } else {
            ByteBuffer buf = ByteBuffer.wrap(data);
            this.status_code = buf.getShort();
            this.local_ip = Utility.byteArrayToString(data, 2, 4, ".");
            if (this.status_code != 0) {
                log.debug((Object)("Port mapping error: " + this.status_code));
                this.forward_status = false;
            } else if (this.skipVerification) {
                log.trace((Object)"Skipping upnp verification...");
                this.forward_status = true;
            } else {
                log.trace((Object)"Executing upnp verification...");
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        UPnPAppHandler.this.testForwarding(UPnPAppHandler.this.id, UPnPAppHandler.this.tested_port);
                    }
                };
                thread.setName("upnpVerify");
                thread.start();
                return false;
            }
        }
        if (this.callback != null) {
            this.callback.forwardingStatus(this, this.forward_status);
        }
        return true;
    }

    private void testForwarding(String id, short port) {
        this.forward_status = this.forwardingWorks(id, port);
        if (this.callback != null) {
            this.callback.forwardingStatus(this, this.forward_status);
        }
        if (!this.forward_status) {
            try {
                this.transmitter.sendData(this, 52, null);
            }
            catch (UPnPAppTransmitter.SendException e) {
                log.debug((Object)("failed to remove forwarding for device " + this.getId() + " on port " + this.getTestedPort()));
            }
        }
        this.transmitter.closeSession();
    }

    public int getStatusCode() {
        return this.status_code;
    }

    public boolean getForwardStatus() {
        return this.forward_status;
    }

    public short getTestedPort() {
        return this.tested_port;
    }

    public String getLocalIp() {
        return this.local_ip;
    }

    public boolean forwardingWorks(String id, short port) {
        Integer gcId;
        block4: {
            gcId = this.getGcId(id);
            if (gcId != null) break block4;
            log.warn((Object)("Not found gcId for id=" + id + "."));
            return false;
        }
        try {
            String uri = this.getUri(port, id, gcId);
            log.info((Object)("checking forwarding for url = " + uri));
            HttpGet httpget = new HttpGet(new URI(uri));
            httpget.setHeader("Connection", "close");
            ResponseHandler<Boolean> responseHandler = new ResponseHandler<Boolean>(){

                public Boolean handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    if (response.getStatusLine().getStatusCode() == 200) {
                        return true;
                    }
                    return false;
                }
            };
            return (Boolean)this.client.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        catch (SSLPeerUnverifiedException e) {
            return true;
        }
        catch (Exception e) {
            log.debug((Object)("Connection error: " + e.getMessage()));
            return false;
        }
    }

    private Integer getGcId(String mac) {
        return 0;
    }

    private String getUri(short port, String id, Integer gcId) {
        StringBuilder uri = new StringBuilder();
        uri.append("https://").append(this.public_ip).append(":").append(port).append("/verify");
        uri.append("?mac=").append(id);
        uri.append("&SERVICE=VERIFY");
        uri.append("&GC_ID=").append(gcId);
        uri.append("&JSESSIONID=").append(this.httpProxySessions.generate());
        return uri.toString();
    }

    public void setupForwarding(short port) throws UPnPAppTransmitter.SendException {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.putShort(port);
        this.transmitter.sendData(this, 48, buf.array());
        this.tested_port = port;
    }

    public String getId() {
        return this.id;
    }

    public String getPublicIp() {
        return this.public_ip;
    }

    public UPnPAppHandler(UPnPAppCallback cb, UPnPAppTransmitter transmitter, HttpClient client, String id, String public_ip, boolean skipVerification, HttpProxySessions httpProxySessions) {
        this.callback = cb;
        this.transmitter = transmitter;
        this.client = client;
        this.id = id;
        this.public_ip = public_ip;
        this.skipVerification = skipVerification;
        this.httpProxySessions = httpProxySessions;
    }
}

