/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.logs;

import com.vestiacom.gdserver.rest.model.LoggerConfigurationStatus;
import homemonitor.GDErrorCode;
import homemonitor.logs.LoggerConfiguratorInterface;
import homemonitor.logs.LoggerConfiguratorReceiverInterface;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class LoggerConfiguratorService
implements LoggerConfiguratorReceiverInterface {
    private static Logger log = Logger.getLogger(LoggerConfiguratorService.class);
    private LoggerConfiguratorInterface loggerConfiguratorInterface;
    private CountDownLatch latch;
    private LoggerConfigurationStatus status = null;
    private long timeout = 20L;

    public LoggerConfiguratorService(LoggerConfiguratorInterface loggerConfiguratorInterface) {
        this.loggerConfiguratorInterface = loggerConfiguratorInterface;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public LoggerConfigurationStatus configureLogs(String deviceID, String logsConfiguration) {
        log.debug((Object)("start configureLogs(deviceID=" + deviceID + ", logsConfiguration=" + logsConfiguration + ")"));
        long sessionID = this.loggerConfiguratorInterface.createSession(deviceID, this);
        if (sessionID == 0L) {
            log.warn((Object)("Failed to configure logger for deviceID " + deviceID + ". Device is not connected!"));
            return LoggerConfigurationStatus.ERROR;
        }
        this.latch = new CountDownLatch(1);
        if (this.loggerConfiguratorInterface.send(sessionID, logsConfiguration) != GDErrorCode.NoError) {
            log.warn((Object)"Error ocured during configuration gateway client logger!");
            return LoggerConfigurationStatus.ERROR;
        }
        try {
            this.latch.await(this.timeout, TimeUnit.SECONDS);
            if (this.latch.getCount() > 0L) {
                log.warn((Object)"ConfigureGCLogsService has timed out while waiting for response");
                return LoggerConfigurationStatus.FAILED_NOANSWER;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.trace((Object)("exit configureLogs(deviceID=" + deviceID + ", logsConfiguration=" + logsConfiguration + "): " + (Object)((Object)this.status) + "."));
        return this.status;
    }

    @Override
    public void received(LoggerConfigurationStatus status) {
        this.status = status;
        this.latch.countDown();
    }

    @Override
    public void deviceDisconnected() {
        this.status = LoggerConfigurationStatus.ERROR;
        this.latch.countDown();
    }
}

