/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.execcmd;

import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.SenderInterface;
import homemonitor.execcmd.ExecCmdCallback;
import homemonitor.execcmd.ExecCmdHandler;
import homemonitor.execcmd.ExecCmdTransmitter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExecCmdApp
extends Application
implements SenderInterface {
    private static Logger log = Logger.getLogger(ExecCmdApp.class);
    private GatewayDeviceConnectionInterface gdc = null;
    private Map<Long, Handle> handles = new HashMap<Long, Handle>();

    public ExecCmdApp() {
    }

    public ExecCmdApp(GatewayDeviceConnectionInterface gdc) {
        this.gdc = gdc;
    }

    void sendData(Handle handle, int tag, byte[] data) throws ExecCmdTransmitter.SendException {
        if (this.gdc.send(tag, handle.getSessionId(), data) != GDErrorCode.NoError) {
            throw new ExecCmdTransmitter.SendException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        Map<Long, Handle> map = this.handles;
        synchronized (map) {
            this.handles.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long serviceId, byte[] data) {
        Handle handle = null;
        Map<Long, Handle> map = this.handles;
        synchronized (map) {
            handle = this.handles.get(serviceId);
        }
        if (handle == null) {
            log.error((Object)"Got data with invalid session id!");
        } else {
            if (handle.getHandler().receivedData(tag, data)) {
                this.handles.remove(serviceId);
                this.gdc.destroySession(serviceId);
            }
            this.sessionDelete(serviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeCommand(Handle handle, String command) {
        long sessionId = this.gdc.createSession(handle.getId(), this);
        if (sessionId == 0L) {
            return false;
        }
        try {
            handle.setSessionId(sessionId);
            handle.getHandler().executeCommand(command);
            Map<Long, Handle> map = this.handles;
            synchronized (map) {
                this.handles.put(sessionId, handle);
            }
            this.sessionAdd(handle.getId(), sessionId);
            return true;
        }
        catch (ExecCmdTransmitter.SendException e) {
            this.gdc.destroySession(sessionId);
            return false;
        }
    }

    public boolean executeCommand(String id, String command, Callback callback) {
        Handle handle = new Handle(callback, id);
        handle.setHandler(new ExecCmdHandler(handle, handle));
        return handle.executeCommand(command);
    }

    public static interface Callback {
        public void execCmdEffect(String var1, String var2, int var3);

        public void execCmdError(String var1);
    }

    public class Handle
    implements ExecCmdCallback,
    ExecCmdTransmitter {
        private ExecCmdHandler handler;
        private Callback callback;
        private String command;
        private long sessionId;
        private String id;

        Handle(Callback callback, String id) {
            this.callback = callback;
            this.id = id;
        }

        long getSessionId() {
            return this.sessionId;
        }

        void setSessionId(long sessionId) {
            this.sessionId = sessionId;
        }

        void setHandler(ExecCmdHandler handler) {
            this.handler = handler;
        }

        ExecCmdHandler getHandler() {
            return this.handler;
        }

        public String getCommand() {
            return this.command;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void sendData(ExecCmdHandler handler, int tag, byte[] data) throws ExecCmdTransmitter.SendException {
            ExecCmdApp.this.sendData(this, tag, data);
        }

        @Override
        public void execCmdEffect(ExecCmdHandler handler, String output, int statusCode) {
            this.callback.execCmdEffect(this.getId(), output, statusCode);
        }

        @Override
        public void execCmdError(ExecCmdHandler handler) {
            this.callback.execCmdError(this.getId());
        }

        public boolean executeCommand(String command) {
            this.command = command;
            return ExecCmdApp.this.executeCommand(this, command);
        }
    }
}

