/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.encryption;

import homemonitor.GatewayDeviceConnection;
import homemonitor.SenderInterface;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class EncryptionHelper
implements SenderInterface {
    private static Logger log = Logger.getLogger(EncryptionHelper.class);
    private static int RESULT_SUCCESS = 0;
    private static int RESULT_FAILURE = 1;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private String keyCertPath;
    private String caCertPath;
    private byte[] keyCert = null;
    private byte[] caCert = null;
    private long keyCertLastModified = 0L;
    private long caCertLastModified = 0L;
    private boolean encryption_jni_loaded = false;

    public native int encryption_init(String var1);

    public native byte[] encryption_dhm_calc_secret(String var1, byte[] var2);

    public native byte[] encryption_rsa_pkcs1_decrypt(String var1, byte[] var2, int var3);

    public native byte[] encryption_rsa_pkcs1_sign(String var1, byte[] var2);

    public native byte[] encryption_sign_message(byte[] var1);

    public EncryptionHelper(GatewayDeviceConnection gatewayDeviceConnection, String keyPath, String keyCertPath, String caCertPath) {
        try {
            System.loadLibrary("EncryptionJNI");
            this.encryption_jni_loaded = true;
        }
        catch (UnsatisfiedLinkError ex) {
            log.warn((Object)("failed to load EncryptionJNI: " + ex.getMessage()));
        }
        this.gatewayDeviceConnection = gatewayDeviceConnection;
        if (this.encryption_jni_loaded && this.encryption_init(keyPath) != 0) {
            log.warn((Object)"cannot initialize crypto context");
        }
        this.keyCertPath = keyCertPath;
        this.caCertPath = caCertPath;
    }

    @Override
    public void deviceDisconnected(String deviceId) {
    }

    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        String appSessionId = String.valueOf(deviceId) + ":" + new Long(sessionId).toString();
        switch (tag) {
            case 96: {
                if (!this.encryption_jni_loaded) break;
                byte[] output = this.encryption_rsa_pkcs1_sign(appSessionId, data);
                this.parseResultAndSendResponse(deviceId, sessionId, output);
                break;
            }
            case 98: {
                ByteBuffer inputBuffer = ByteBuffer.wrap(data);
                int maxOutputSize = inputBuffer.getInt();
                byte[] input = new byte[data.length - 4];
                inputBuffer.get(input);
                if (!this.encryption_jni_loaded) break;
                byte[] output = this.encryption_rsa_pkcs1_decrypt(appSessionId, input, maxOutputSize);
                this.parseResultAndSendResponse(deviceId, sessionId, output);
                break;
            }
            case 100: {
                if (!this.encryption_jni_loaded) break;
                byte[] output = this.encryption_dhm_calc_secret(appSessionId, data);
                this.parseResultAndSendResponse(deviceId, sessionId, output);
                break;
            }
            default: {
                log.warn((Object)"received invalid tag from GC");
            }
        }
    }

    private void parseResultAndSendResponse(String deviceId, Long sessionId, byte[] result) {
        byte[] response = new byte[4 + (result != null ? result.length : 0)];
        ByteBuffer buffer = ByteBuffer.wrap(response);
        buffer.putInt(result != null ? RESULT_SUCCESS : RESULT_FAILURE);
        if (result != null) {
            buffer.put(result);
        }
        this.gatewayDeviceConnection.sendSimple(97, deviceId, sessionId.toString(), response);
    }

    public int getKeyCertLength() {
        this.updateKeeyIfNeeded(CertificateType.KeyCertificate);
        return this.keyCert.length;
    }

    public int getCaCertLength() {
        this.updateKeeyIfNeeded(CertificateType.CaCertificate);
        return this.caCert.length;
    }

    public byte[] getKeyCert() {
        this.updateKeeyIfNeeded(CertificateType.KeyCertificate);
        return this.keyCert;
    }

    public byte[] getCaCert() {
        this.updateKeeyIfNeeded(CertificateType.CaCertificate);
        return this.caCert;
    }

    private void updateKeeyIfNeeded(CertificateType type) {
        String path = null;
        long lastModified = 0L;
        switch (type) {
            case KeyCertificate: {
                path = this.keyCertPath;
                lastModified = this.keyCertLastModified;
                break;
            }
            case CaCertificate: {
                path = this.caCertPath;
                lastModified = this.caCertLastModified;
            }
        }
        File file = new File(path);
        if (file.lastModified() > lastModified) {
            this.loadCertificate(type, file);
        }
    }

    private void loadCertificate(CertificateType type, File file) {
        block16: {
            RandomAccessFile randomAccessFile = null;
            try {
                try {
                    randomAccessFile = new RandomAccessFile(file, "r");
                    switch (type) {
                        case KeyCertificate: {
                            this.keyCert = new byte[(int)randomAccessFile.length()];
                            randomAccessFile.readFully(this.keyCert);
                            this.keyCertLastModified = file.lastModified();
                            break;
                        }
                        case CaCertificate: {
                            this.caCert = new byte[(int)randomAccessFile.length()];
                            randomAccessFile.readFully(this.caCert);
                            this.caCertLastModified = file.lastModified();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (randomAccessFile == null) break block16;
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Error while closing file (" + file.getName() + "):" + e2.getMessage()));
                    }
                }
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Error while closing file (" + file.getName() + "):" + e.getMessage()));
                    }
                }
            }
        }
    }

    private static enum CertificateType {
        KeyCertificate,
        CaCertificate;

    }
}

