/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.UDPProxy;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import homemonitor.UDPProxy.LANDeviceDiscoveryNotification;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.UDPProxyResponseInterface;
import homemonitor.Utility;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class VivotekCameraDiscovery
implements UDPProxyResponseInterface {
    protected Timer timerQuery = new Timer();
    protected Timer timerStop = new Timer();
    protected UDPProxyInterface udpProxy;
    protected LANDeviceDiscoveryNotification notification;
    protected long sessionId;
    protected HashMap<String, DiscoveredLanDevice> foundDevices = new HashMap();
    protected boolean noTimers = false;

    public VivotekCameraDiscovery(UDPProxyInterface udpProxy, LANDeviceDiscoveryNotification notification) {
        this(udpProxy, notification, false);
    }

    public VivotekCameraDiscovery(UDPProxyInterface udpProxy, LANDeviceDiscoveryNotification notification, boolean noTimers) {
        this.udpProxy = udpProxy;
        this.notification = notification;
        this.noTimers = noTimers;
    }

    public void sendBroadcast() {
        byte[] broadcastMessage = new byte[]{1, 94, 1, 28, 1};
        this.udpProxy.send(this.sessionId, -1L, 10000, broadcastMessage);
    }

    public void stopWaiting() {
        this.udpProxy.close(this.sessionId);
        if (this.notification != null) {
            this.notification.discoveryFinished();
        }
    }

    public void discover(String deviceId) {
        this.foundDevices.clear();
        this.sessionId = this.udpProxy.createSession(deviceId, this);
        if (this.sessionId == 0L) {
            this.stopWaiting();
            return;
        }
        if (this.noTimers) {
            return;
        }
        this.timerQuery.schedule(new TimerTask(){
            private int cnt = 10;

            @Override
            public void run() {
                VivotekCameraDiscovery.this.sendBroadcast();
                if (this.cnt-- == 0) {
                    this.cancel();
                }
            }
        }, 0L, 500L);
        this.timerStop.schedule(new TimerTask(){

            @Override
            public void run() {
                VivotekCameraDiscovery.this.stopWaiting();
            }
        }, 6000L);
    }

    @Override
    public void deviceDisconnected(long sessionId) {
        this.timerQuery.cancel();
        this.timerStop.cancel();
        this.stopWaiting();
        if (this.notification != null) {
            this.notification.discoveryError();
        }
    }

    @Override
    public void received(int srcAddress, int srcPort, byte[] data) {
        String name = null;
        String mac = null;
        String ipAddress = null;
        byte[] cookie = new byte[]{2, 94, 1, 28, 1};
        int i = 0;
        while (i < cookie.length) {
            if (data[i] != cookie[i]) {
                return;
            }
            ++i;
        }
        int offset = cookie.length;
        while (offset < data.length) {
            byte tag = data[offset++];
            byte len = data[offset++];
            byte[] val = new byte[len];
            System.arraycopy(data, offset, val, 0, len);
            switch (tag) {
                case 1: {
                    name = Utility.byteArrayASCIIToString(val);
                    break;
                }
                case 2: {
                    mac = Utility.byteArrayToHexString(val, 0, val.length, ":");
                    break;
                }
                case 3: {
                    ipAddress = Utility.byteArrayToString(val, 0, 4, ".");
                }
            }
            offset += len;
        }
        if (name != null && mac != null) {
            DiscoveredLanDevice dev = new DiscoveredLanDevice(mac, ipAddress, name);
            dev.setPort(80);
            if (!this.foundDevices.containsKey(mac)) {
                this.foundDevices.put(mac, dev);
                dev.setDeviceDriver("CameraVivotekGeneric");
                if (this.notification != null) {
                    this.notification.foundNewLANDevice(dev);
                }
            }
        }
    }
}

