/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.UDPProxy;

import homemonitor.GDErrorCode;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.UDPProxyResponseInterface;
import homemonitor.Utility;

public class UDPProxyNetworkTest
implements UDPProxyResponseInterface {
    UDPProxyInterface proxy;
    String address;
    long addressLong;
    int port;
    int limit;
    long sessionId;
    byte counter = 0;
    long interval;
    String deviceId;
    Thread thread = new Thread(){

        @Override
        public void run() {
            while (UDPProxyNetworkTest.this.limit == 0 || UDPProxyNetworkTest.this.counter < UDPProxyNetworkTest.this.limit) {
                byte[] byArray = new byte[1];
                byte by = UDPProxyNetworkTest.this.counter;
                UDPProxyNetworkTest.this.counter = (byte)(by + 1);
                byArray[0] = by;
                GDErrorCode result = UDPProxyNetworkTest.this.proxy.send(UDPProxyNetworkTest.this.sessionId, UDPProxyNetworkTest.this.addressLong, UDPProxyNetworkTest.this.port, byArray);
                if (result != GDErrorCode.NoError) {
                    System.out.println("UDPProxyNetworkTest: Cannot send message to GC. Exiting.");
                    return;
                }
                try {
                    1.sleep(UDPProxyNetworkTest.this.interval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public UDPProxyNetworkTest(UDPProxyInterface proxy, String deviceId, String address, int port) {
        this.proxy = proxy;
        this.deviceId = deviceId;
        this.address = address;
        String[] addressOctets = address.split("\\.");
        byte[] addressBytes = new byte[4];
        int i = 0;
        while (i < 4) {
            addressBytes[i] = (byte)Integer.parseInt(addressOctets[i]);
            ++i;
        }
        this.addressLong = Utility.byteArrayToInt(addressBytes);
        this.port = port;
    }

    @Override
    public void received(int srcAddress, int srcPort, byte[] data) {
        System.out.println("UDPProxyNetworkTest.received() called. Should never happen.");
    }

    @Override
    public void deviceDisconnected(long sessionId) {
        System.out.println("UDPProxyNetworkTest: device disconnected.");
        this.limit = 0;
        this.proxy.close(sessionId);
    }

    public void start(long interval, int repetitions) {
        this.interval = interval;
        this.limit = repetitions;
        this.sessionId = this.proxy.createSession(this.deviceId, this);
        if (this.sessionId == 0L) {
            return;
        }
        this.thread.start();
    }
}

