/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.TCPProxy;

import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.TCPProxy.TCPProxyInterface;
import homemonitor.TCPProxy.TCPProxyResponseInterface;
import homemonitor.Utility;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class TCPProxy
extends Application
implements TCPProxyInterface {
    private static final int DATA_MAX_SIZE = 1188;
    private static Logger log = Logger.getLogger(TCPProxy.class);
    final int TPCookie = 151;
    final int StatusTag = 0;
    final int TCPConnectTag = 128;
    final int TCPAcceptedTag = 129;
    final int TCPReceivedTag = 130;
    final int TCPSendTag = 131;
    final int TCPErrorTag = 132;
    final int TCPClosedTag = 133;
    final int TCPCloseTag = 134;
    final int TCPReceiveAck = 135;
    final int TCPKeepAlive = 136;
    final int TCPKeepAliveResp = 137;
    private GatewayDeviceConnectionInterface gatewayDeviceConnection;
    private Map<Long, TCPProxyResponseInterface> responseHandlerMap = new HashMap<Long, TCPProxyResponseInterface>();
    private Map<Long, Boolean> keepaliveMap = new HashMap<Long, Boolean>();
    private Map<Long, ByteBuffer> sessionData = new HashMap<Long, ByteBuffer>();
    private Set<Long> closedWaitingForStatus = new HashSet<Long>();
    private Timer keepaliveCheckTimer = new Timer();

    public TCPProxy(GatewayDeviceConnectionInterface gdc) {
        this.gatewayDeviceConnection = gdc;
        this.keepaliveCheckTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                TCPProxy.this.removeDeadDevices();
            }
        }, 30000L, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        Map<Long, Object> map = this.responseHandlerMap;
        synchronized (map) {
            TCPProxyResponseInterface resp = this.responseHandlerMap.remove(sessionId);
            if (resp != null) {
                resp.deviceDisconnected(sessionId);
            }
            this.sessionData.remove(sessionId);
        }
        map = this.keepaliveMap;
        synchronized (map) {
            this.keepaliveMap.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        TCPProxyResponseInterface response;
        Object object = this.responseHandlerMap;
        synchronized (object) {
            response = this.responseHandlerMap.get(sessionId);
        }
        if (tag < 0) {
            tag += 256;
        }
        if (response == null) {
            switch (tag) {
                case 133: {
                    break;
                }
                case 0: {
                    object = this.closedWaitingForStatus;
                    synchronized (object) {
                        if (!this.closedWaitingForStatus.remove(sessionId)) {
                            log.debug((Object)("TCPProxy: received StatusTag for session not waiting for one, from device: " + deviceId));
                        }
                        break;
                    }
                }
                default: {
                    log.debug((Object)("TCPProxy: received response when session " + sessionId + " closed already, from device: " + deviceId));
                    log.debug((Object)("   tag = " + tag));
                    log.debug((Object)("   sessionid = " + sessionId));
                    log.debug((Object)("   data = [" + (data != null ? Integer.valueOf(data.length) : "-") + "] " + (data != null ? new String(data) : "<null>")));
                }
            }
            return;
        }
        this.updateAlive(sessionId);
        switch (tag) {
            case 0: {
                if (data[0] != 0) {
                    log.warn((Object)"TCPProxy: got Status Error from GD.");
                    response.error(sessionId);
                    this.responseHandlerMap.remove(sessionId);
                    break;
                }
                this.send(sessionId, null);
                break;
            }
            case 129: {
                response.accepted(sessionId);
                break;
            }
            case 133: {
                log.debug((Object)"TCPProxy received TCPClosedTag");
                response.closed(sessionId);
                this.responseHandlerMap.remove(sessionId);
                break;
            }
            case 132: {
                response.error(sessionId);
                this.responseHandlerMap.remove(sessionId);
                break;
            }
            case 130: {
                response.received(sessionId, data);
                GatewayDevice gd = this.gatewayDeviceConnection.findBySessionId(sessionId);
                if (gd != null && gd.deviceType == 0) {
                    byte[] receivedLen = new byte[2];
                    System.arraycopy(Utility.intToByteArray(data.length), 2, receivedLen, 0, 2);
                    this.gatewayDeviceConnection.send(135, sessionId, receivedLen);
                    log.debug((Object)"got message and sending ACK");
                    break;
                }
                log.debug((Object)"got message and NOT sending ACK");
                break;
            }
            case 136: {
                this.gatewayDeviceConnection.send(137, sessionId, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAlive(long sessionId) {
        Map<Long, Boolean> map = this.keepaliveMap;
        synchronized (map) {
            this.keepaliveMap.put(sessionId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode send(long sessionId, byte[] data) {
        log.trace((Object)("TCPProxy: send(sessionId=" + sessionId + ", data=" + (data == null ? "null" : (Object)data) + ")"));
        log.debug((Object)("data size: " + (data == null ? "null" : Integer.valueOf(data.length))));
        Map<Long, TCPProxyResponseInterface> map = this.responseHandlerMap;
        synchronized (map) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                return GDErrorCode.WrongSessionID;
            }
        }
        ByteBuffer buffer = this.sessionData.get(sessionId);
        if (buffer == null) {
            if (data == null) {
                return GDErrorCode.NoError;
            }
            buffer = ByteBuffer.wrap(data);
            buffer.position(data.length);
            this.sessionData.put(sessionId, buffer);
        } else if (data != null) {
            if (buffer.remaining() < data.length) {
                buffer.flip();
                ByteBuffer newBuffer = ByteBuffer.allocate(buffer.remaining() + data.length);
                newBuffer.clear();
                newBuffer.put(buffer);
                buffer = newBuffer;
                this.sessionData.put(sessionId, buffer);
            }
            buffer.put(data);
        }
        if (buffer.position() == 0 && data == null) {
            return GDErrorCode.NoError;
        }
        byte[] bucket = this.prepareDataBucket(buffer);
        log.debug((Object)("bucket size: " + (bucket == null ? "null" : Integer.valueOf(bucket.length))));
        if (bucket == null) {
            return GDErrorCode.NoError;
        }
        GDErrorCode errorCode = this.gatewayDeviceConnection.send(131, sessionId, bucket);
        return errorCode;
    }

    private byte[] prepareDataBucket(ByteBuffer buffer) {
        byte[] part = new byte[buffer.position() > 1188 ? 1188 : buffer.position()];
        buffer.flip();
        buffer.get(part);
        buffer.compact();
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode disconnect(long sessionId) {
        log.debug((Object)"TCPProxy disconnect");
        Object object = this.keepaliveMap;
        synchronized (object) {
            this.keepaliveMap.remove(sessionId);
        }
        object = this.responseHandlerMap;
        synchronized (object) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                return GDErrorCode.WrongSessionID;
            }
            this.responseHandlerMap.remove(sessionId);
        }
        object = this.closedWaitingForStatus;
        synchronized (object) {
            this.closedWaitingForStatus.add(sessionId);
        }
        GDErrorCode errorCode = this.gatewayDeviceConnection.send(134, sessionId, null);
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long connect(String deviceId, String dstAddress, int dstPort, TCPProxyResponseInterface responseHandler) {
        GDErrorCode code;
        long sessionId = this.gatewayDeviceConnection.createSession(deviceId, this);
        if (sessionId == 0L) {
            return 0L;
        }
        if (dstPort != 0) {
            String[] dstAddrSArray = dstAddress.split("\\.");
            byte[] connectPayload = new byte[6];
            int i = 0;
            while (i < 4) {
                connectPayload[i] = (byte)Integer.parseInt(dstAddrSArray[i]);
                ++i;
            }
            byte[] portArray = Utility.intToByteArray(dstPort);
            System.arraycopy(portArray, 2, connectPayload, 4, 2);
            code = this.gatewayDeviceConnection.send(128, sessionId, connectPayload);
        } else {
            byte[] dstAddressBytes = null;
            try {
                dstAddressBytes = dstAddress.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException connectPayload) {
                // empty catch block
            }
            byte[] connectPayload = new byte[6 + dstAddressBytes.length + 1];
            int i = 0;
            while (i < 6) {
                connectPayload[i] = 0;
                ++i;
            }
            System.arraycopy(dstAddressBytes, 0, connectPayload, 6, dstAddressBytes.length);
            connectPayload[6 + dstAddressBytes.length] = 0;
            code = this.gatewayDeviceConnection.send(128, sessionId, connectPayload);
        }
        if (code != GDErrorCode.NoError) {
            return 0L;
        }
        Map<Long, Object> map = this.responseHandlerMap;
        synchronized (map) {
            this.responseHandlerMap.put(sessionId, responseHandler);
        }
        map = this.keepaliveMap;
        synchronized (map) {
            this.keepaliveMap.put(sessionId, true);
        }
        this.sessionAdd(deviceId, sessionId);
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeadDevices() {
        ArrayList<Long> to_false = new ArrayList<Long>();
        ArrayList<Long> to_disconnect = new ArrayList<Long>();
        Map<Long, Boolean> map = this.keepaliveMap;
        synchronized (map) {
            for (Map.Entry<Long, Boolean> entry : this.keepaliveMap.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    to_false.add(entry.getKey());
                    continue;
                }
                to_disconnect.add(entry.getKey());
            }
            for (Long key : to_false) {
                this.keepaliveMap.put(key, false);
            }
            for (Long key : to_disconnect) {
                this.disconnect(key);
            }
        }
    }
}

