/*
 * Decompiled with CFR 0.152.
 */
package homemonitor;

import homemonitor.ServerBackendInterface;
import homemonitor.ServerBackendReceiverInterface;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ServerBackend
implements ServerBackendInterface {
    private static Logger log = Logger.getLogger(ServerBackend.class);
    private ServerSocketChannel server;
    private Selector selector;
    private ServerBackendReceiverInterface receiver;
    private HashMap<String, SocketChannel> unverifiedSockets = new HashMap();
    private HashMap<String, SocketChannel> sockets = new HashMap();
    private HashMap<SocketChannel, List<ByteBuffer>> pendingData = new HashMap();
    private Set<SocketChannel> closePending = new HashSet<SocketChannel>();
    private long lastUnverifiedSocketId = 0L;
    final int Port;
    final int BufferSize = 2048;
    final String IPAddress;
    boolean running = true;
    private long checkPeriodSeconds = 900L;
    private int backlog = 1024;
    private Thread purgeThread = new Thread(){

        @Override
        public void run() {
            super.setName("GDServerBackendPurgeThread");
            try {
                while (ServerBackend.this.running) {
                    ServerBackend.this.receiver.purgeDeadDevices(2L * ServerBackend.this.checkPeriodSeconds);
                    Thread.sleep(ServerBackend.this.checkPeriodSeconds * 1000L);
                }
            }
            catch (InterruptedException ex) {
                log.debug((Object)"Interrupted purge thread", (Throwable)ex);
            }
            catch (Exception exception) {
                log.debug((Object)"Exception in purge thread", (Throwable)exception);
            }
        }
    };
    private Thread networkThread = new Thread(){

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            super.setName("GDServerBackendCommThread");
            while (ServerBackend.this.running) {
                try {
                    ServerBackend.this.server = ServerSocketChannel.open();
                    ServerBackend.this.server.socket().setReuseAddress(true);
                    ServerBackend.this.server.configureBlocking(false);
                    ServerBackend.this.server.socket().setReuseAddress(true);
                    ServerBackend.this.server.socket().bind(new InetSocketAddress(ServerBackend.this.IPAddress, ServerBackend.this.Port), ServerBackend.this.backlog);
                    ServerBackend.this.selector = Selector.open();
                    ServerBackend.this.server.register(ServerBackend.this.selector, 16);
                    while (ServerBackend.this.running) {
                        ServerBackend.this.listen();
                    }
                    ServerBackend.this.selector.close();
                    ServerBackend.this.server.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ServerBackend.this.selector.close();
                        ServerBackend.this.server.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                catch (InterruptedException ex) {
                    try {
                        ServerBackend.this.selector.close();
                        ServerBackend.this.server.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        try {
                            ServerBackend.this.selector.close();
                            ServerBackend.this.server.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    ServerBackend.this.selector.close();
                    ServerBackend.this.server.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    };

    public void setCheckPeriodSeconds(long checkPeriodSeconds) {
        this.checkPeriodSeconds = checkPeriodSeconds;
    }

    public void beanDestroyed() {
        this.running = false;
        this.selector.wakeup();
        this.networkThread.interrupt();
        this.purgeThread.interrupt();
        try {
            this.networkThread.join();
            this.purgeThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() throws Exception {
        if (this.selector.select() == 0) {
            return;
        }
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> i = keys.iterator();
        while (i.hasNext()) {
            SelectionKey key = i.next();
            i.remove();
            try {
                Object object;
                String id;
                Object unvId;
                SocketChannel client;
                if (key.isAcceptable()) {
                    client = this.server.accept();
                    client.configureBlocking(false);
                    SelectionKey newKey = client.register(this.selector, 1);
                    ++this.lastUnverifiedSocketId;
                    this.lastUnverifiedSocketId %= Long.MAX_VALUE;
                    unvId = "" + this.lastUnverifiedSocketId;
                    newKey.attach(unvId);
                    this.unverifiedSockets.put((String)unvId, client);
                    log.trace((Object)("Connected device with temp id: " + unvId));
                    continue;
                }
                if (key.isReadable()) {
                    int numRead;
                    ByteBuffer buffer;
                    block60: {
                        client = (SocketChannel)key.channel();
                        if (this.closePending.contains(client)) {
                            String id2 = key.attachment().toString();
                            unvId = this.sockets;
                            synchronized (unvId) {
                                if (client.equals(this.sockets.get(id2))) {
                                    this.sockets.remove(id2);
                                }
                            }
                            unvId = this.unverifiedSockets;
                            synchronized (unvId) {
                                if (client.equals(this.unverifiedSockets.get(id2))) {
                                    this.unverifiedSockets.remove(id2);
                                }
                            }
                            unvId = this.pendingData;
                            synchronized (unvId) {
                                this.pendingData.remove(client);
                            }
                            unvId = this.closePending;
                            synchronized (unvId) {
                                this.closePending.remove(client);
                            }
                            key.cancel();
                            client.close();
                            continue;
                        }
                        buffer = ByteBuffer.allocate(2048);
                        try {
                            numRead = client.read(buffer);
                            if (numRead == -1) break block60;
                            buffer.limit(numRead);
                        }
                        catch (IOException exception) {
                            this.deviceDisconnected((String)key.attachment());
                            key.cancel();
                            client.close();
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.deviceDisconnected((String)key.attachment());
                            key.cancel();
                            client.close();
                            continue;
                        }
                    }
                    if (numRead == -1) {
                        this.deviceDisconnected((String)key.attachment());
                        key.cancel();
                        client.close();
                        continue;
                    }
                    log.trace((Object)("SB received from device: " + numRead));
                    this.receiver.receivedData(client.socket().getInetAddress().getHostAddress(), key.attachment().toString(), buffer);
                    continue;
                }
                if (!key.isWritable()) continue;
                SocketChannel socket = (SocketChannel)key.channel();
                try {
                    int writeSelectionKey = 0;
                    HashMap<SocketChannel, List<ByteBuffer>> numRead = this.pendingData;
                    synchronized (numRead) {
                        List<ByteBuffer> queue = this.pendingData.get(socket);
                        if (queue == null) {
                            continue;
                        }
                        if (!queue.isEmpty()) {
                            ByteBuffer buffer = queue.get(0);
                            socket.write(buffer);
                            log.trace((Object)("SB sent to device: " + buffer.position()));
                            if (buffer.remaining() == 0) {
                                queue.remove(0);
                            }
                        }
                        if (!queue.isEmpty()) {
                            writeSelectionKey = 4;
                        }
                        key.interestOps(1 + writeSelectionKey);
                    }
                    if (!this.closePending.contains(socket)) continue;
                    id = key.attachment().toString();
                    object = this.sockets;
                    synchronized (object) {
                        if (socket.equals(this.sockets.get(id))) {
                            this.sockets.remove(id);
                        }
                    }
                    object = this.unverifiedSockets;
                    synchronized (object) {
                        if (socket.equals(this.unverifiedSockets.get(id))) {
                            this.unverifiedSockets.remove(id);
                        }
                    }
                    object = this.pendingData;
                    synchronized (object) {
                        this.pendingData.remove(socket);
                    }
                    object = this.closePending;
                    synchronized (object) {
                        this.closePending.remove(socket);
                    }
                    key.cancel();
                    socket.close();
                }
                catch (IOException exception) {
                    id = (String)key.attachment();
                    log.debug((Object)("Recovered from exception " + exception.getMessage() + " : closing connection with the device: " + id));
                    object = this.unverifiedSockets;
                    synchronized (object) {
                        this.unverifiedSockets.remove(id);
                    }
                    object = this.sockets;
                    synchronized (object) {
                        this.sockets.remove(id);
                    }
                    object = this.pendingData;
                    synchronized (object) {
                        this.pendingData.remove(socket);
                    }
                    object = this.closePending;
                    synchronized (object) {
                        this.closePending.remove(key.channel());
                    }
                    key.cancel();
                    socket.close();
                    this.receiver.deviceDisconnected(id);
                }
            }
            catch (CancelledKeyException ex) {
                log.debug((Object)("Attempt to use selection key that is no longer valid: " + ex.getMessage()));
            }
        }
    }

    private void deviceDisconnected(String deviceId) {
        SocketChannel sock = this.sockets.remove(deviceId);
        if (sock != null) {
            this.closePending.remove(sock);
            this.receiver.deviceDisconnected(deviceId);
        }
        if ((sock = this.unverifiedSockets.remove(deviceId)) != null) {
            this.closePending.remove(sock);
            log.trace((Object)("Disconnected device with temp id: " + deviceId));
        }
    }

    @Override
    public void close(String deviceId) {
        SocketChannel sock = null;
        sock = this.sockets.get(deviceId);
        if (sock != null) {
            this.addToClosePending(deviceId, sock);
        }
        if ((sock = this.unverifiedSockets.get(deviceId)) != null) {
            this.addToClosePending(deviceId, sock);
        }
    }

    private void addToClosePending(String deviceId, SocketChannel sock) {
        this.closePending.add(sock);
        this.send(deviceId, new byte[0]);
    }

    public ServerBackend(String ip, int port, ServerBackendReceiverInterface receiver, int backlog, int checkPeriodSeconds) {
        this.receiver = receiver;
        this.IPAddress = ip;
        this.Port = port;
        this.backlog = backlog;
        this.checkPeriodSeconds = checkPeriodSeconds;
        try {
            this.networkThread.start();
            this.purgeThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String id, byte[] data) {
        SocketChannel socket = this.sockets.get(id);
        if (socket == null) {
            socket = this.unverifiedSockets.get(id);
        }
        if (socket == null) {
            log.info((Object)("Cannot send to " + id + " (socket=null)"));
            return;
        }
        SelectionKey key = socket.keyFor(this.selector);
        if (key == null) {
            log.warn((Object)("Cannot send to " + id + " (no key for selector)"));
            return;
        }
        HashMap<SocketChannel, List<ByteBuffer>> hashMap = this.pendingData;
        synchronized (hashMap) {
            List<ByteBuffer> queue = this.pendingData.get(socket);
            if (queue == null) {
                queue = new ArrayList<ByteBuffer>();
                this.pendingData.put(socket, queue);
            }
            queue.add(ByteBuffer.wrap(data));
        }
        key.interestOps(4);
        this.selector.wakeup();
    }

    @Override
    public void deviceVerified(String oldId, String newId) {
        SocketChannel socket = this.unverifiedSockets.get(oldId);
        if (socket == null) {
            return;
        }
        SelectionKey key = socket.keyFor(this.selector);
        key.attach(newId);
        this.unverifiedSockets.remove(oldId);
        this.sockets.put(newId, socket);
    }
}

