/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.RestProxyHelper;

import homemonitor.GatewayDeviceConnection;
import java.nio.ByteBuffer;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class RestProxyHelper {
    private static Logger log = Logger.getLogger(RestProxyHelper.class);
    private String mac;
    private short id;
    private String path;
    private GatewayDeviceConnection gatewayDeviceConnection;
    private String restUrl;
    private HttpClient httpClient;
    private HttpGet httpget;
    private final int requestTimeoutMilliseconds = 5000;
    private final int socketTimeoutMilliseconds = 5000;

    public RestProxyHelper(String deviceId, short id, String path, GatewayDeviceConnection gatewayDeviceConnection, HttpClient httpClient, String restUrl) {
        this.mac = deviceId;
        this.id = id;
        this.path = path;
        this.gatewayDeviceConnection = gatewayDeviceConnection;
        this.httpClient = httpClient;
        this.restUrl = restUrl;
    }

    public void start() {
        new Thread(){

            @Override
            public void run() {
                String response;
                block5: {
                    HttpParams params = RestProxyHelper.this.httpClient.getParams();
                    HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)5000);
                    HttpConnectionParams.setSoTimeout((HttpParams)params, (int)5000);
                    response = null;
                    try {
                        try {
                            RestProxyHelper.this.httpget = new HttpGet(RestProxyHelper.this.getRestProxyPath());
                            BasicResponseHandler responseHandler = new BasicResponseHandler();
                            response = (String)RestProxyHelper.this.httpClient.execute((HttpUriRequest)RestProxyHelper.this.httpget, (ResponseHandler)responseHandler);
                        }
                        catch (Throwable e) {
                            log.warn((Object)("Connection error: " + e.getMessage()));
                            RestProxyHelper.this.httpClient.getConnectionManager().shutdown();
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        RestProxyHelper.this.httpClient.getConnectionManager().shutdown();
                        throw throwable;
                    }
                    RestProxyHelper.this.httpClient.getConnectionManager().shutdown();
                }
                RestProxyHelper.this.sendResponse(response);
            }
        }.start();
    }

    protected String getRestProxyPath() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.restUrl);
        builder.append("/internal/gd/restproxy");
        builder.append(this.path);
        builder.append(this.path.contains("?") ? "&" : "?");
        builder.append("mac=" + this.mac);
        return builder.toString();
    }

    protected void sendResponse(String response) {
        ByteBuffer buffer = ByteBuffer.allocate(4 + (response != null ? response.length() : 0));
        buffer.putShort(this.id);
        if (response != null) {
            buffer.put(response.getBytes());
        }
        this.gatewayDeviceConnection.sendSimple(23, this.mac, buffer.array());
    }
}

